/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.system.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.system.SystemSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class SystemSamplerGui
extends AbstractSamplerGui
implements ItemListener {
    private static final long serialVersionUID = -2413845772703695934L;
    private JCheckBox checkReturnCode;
    private JLabeledTextField desiredReturnCode;
    private JLabeledTextField directory;
    private JLabeledTextField command;
    private ArgumentsPanel argsPanel;
    private ArgumentsPanel envPanel;

    public SystemSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "system_sampler_title";
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)this.getLabelResource());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panelb = new VerticalPanel();
        panelb.add(this.makeReturnCodePanel());
        panelb.add(Box.createVerticalStrut(5));
        panelb.add((Component)this.makeCommandPanel(), "Center");
        this.add((Component)panelb, "Center");
    }

    public TestElement createTestElement() {
        SystemSampler sampler = new SystemSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        super.configureTestElement(sampler);
        SystemSampler systemSampler = (SystemSampler)sampler;
        systemSampler.setCheckReturnCode(this.checkReturnCode.isSelected());
        if (this.checkReturnCode.isSelected()) {
            if (!StringUtils.isEmpty((String)this.desiredReturnCode.getText())) {
                systemSampler.setExpectedReturnCode(Integer.parseInt(this.desiredReturnCode.getText()));
            } else {
                systemSampler.setExpectedReturnCode(0);
            }
        } else {
            systemSampler.setExpectedReturnCode(0);
        }
        systemSampler.setCommand(this.command.getText());
        systemSampler.setArguments((Arguments)this.argsPanel.createTestElement());
        systemSampler.setEnvironmentVariables((Arguments)this.envPanel.createTestElement());
        systemSampler.setDirectory(this.directory.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        SystemSampler systemSampler = (SystemSampler)el;
        this.checkReturnCode.setSelected(systemSampler.getCheckReturnCode());
        this.desiredReturnCode.setText(Integer.toString(systemSampler.getExpectedReturnCode()));
        this.desiredReturnCode.setEnabled(this.checkReturnCode.isSelected());
        this.command.setText(systemSampler.getCommand());
        this.argsPanel.configure((TestElement)systemSampler.getArguments());
        this.envPanel.configure((TestElement)systemSampler.getEnvironmentVariables());
        this.directory.setText(systemSampler.getDirectory());
    }

    private JPanel makeReturnCodePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"return_code_config_box_title")));
        this.checkReturnCode = new JCheckBox(JMeterUtils.getResString((String)"check_return_code_title"));
        this.checkReturnCode.addItemListener(this);
        this.desiredReturnCode = new JLabeledTextField(JMeterUtils.getResString((String)"expected_return_code_title"));
        this.desiredReturnCode.setSize(this.desiredReturnCode.getSize().height, 30);
        panel.add(this.checkReturnCode);
        panel.add(Box.createHorizontalStrut(5));
        panel.add((Component)this.desiredReturnCode);
        this.checkReturnCode.setSelected(true);
        return panel;
    }

    private JPanel makeCommandPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"command_config_box_title")));
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new BoxLayout(cmdPanel, 0));
        this.directory = new JLabeledTextField(JMeterUtils.getResString((String)"directory_field_title"));
        cmdPanel.add((Component)this.directory);
        cmdPanel.add(Box.createHorizontalStrut(5));
        this.command = new JLabeledTextField(JMeterUtils.getResString((String)"command_field_title"));
        cmdPanel.add((Component)this.command);
        panel.add((Component)cmdPanel, "North");
        panel.add((Component)this.makeArgumentsPanel(), "Center");
        panel.add((Component)this.makeEnvironmentPanel(), "South");
        return panel;
    }

    private JPanel makeArgumentsPanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"arguments_panel_title"), null, true, false, new ObjectTableModel(new String[]{"value"}, Argument.class, new Functor[]{new Functor("getValue")}, new Functor[]{new Functor("setValue")}, new Class[]{String.class}));
        return this.argsPanel;
    }

    private JPanel makeEnvironmentPanel() {
        this.envPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"environment_panel_title"));
        return this.envPanel;
    }

    public void clearGui() {
        super.clearGui();
        this.directory.setText("");
        this.command.setText("");
        this.argsPanel.clearGui();
        this.envPanel.clearGui();
        this.desiredReturnCode.setText("");
        this.checkReturnCode.setSelected(false);
        this.desiredReturnCode.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkReturnCode) {
            this.desiredReturnCode.setEnabled(e.getStateChange() == 1);
        }
    }
}

