/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.TextMessageRenderer;

class BinaryMessageRenderer
implements MessageRenderer<byte[]> {
    private TextMessageRenderer delegate;

    public BinaryMessageRenderer(TextMessageRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public byte[] getValueFromText(String text) {
        throw new UnsupportedOperationException(String.format("Type of input not handled: %s", "jms_use_text"));
    }

    @Override
    public byte[] getValueFromFile(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        byte[] bytes;
        if (hasVariable) {
            Object stringValue = this.delegate.getValueFromFile(filename, encoding, hasVariable, (Cache)cache);
            try {
                bytes = ((String)stringValue).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to read " + filename, e);
            }
        } else {
            bytes = (byte[])cache.get((Object)filename, _p -> this.getContent(filename));
        }
        return bytes;
    }

    byte[] getContent(String filename) {
        try {
            return Files.readAllBytes(Paths.get(filename, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can't read content of %s", filename), e);
        }
    }
}

