/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.JMSProperty;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMSPropertiesPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2893899384410289131L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final int COL_NAME = 0;
    private static final int COL_VALUE = 1;
    private static final int COL_TYPE = 2;
    private InnerTableModel tableModel = new InnerTableModel();
    private JTable jmsPropertiesTable;
    private JButton addButton;
    private JButton deleteButton;

    public JMSPropertiesPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        JMSProperties jmsProperties = this.tableModel.jmsProperties;
        return (TestElement)jmsProperties.clone();
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.jmsPropertiesTable);
        JMSProperties jmsProperties = (JMSProperties)el;
        jmsProperties.clear();
        jmsProperties.addTestElement((TestElement)this.tableModel.jmsProperties.clone());
    }

    public void clearGui() {
        this.tableModel.clearData();
        this.deleteButton.setEnabled(false);
    }

    public void configure(TestElement el) {
        this.tableModel.jmsProperties.clear();
        this.tableModel.jmsProperties.addTestElement((TestElement)((JMSProperties)el.clone()));
        if (this.tableModel.getRowCount() != 0) {
            this.deleteButton.setEnabled(true);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add((Component)this.createPropertiesPanel(), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE_COMMAND)) {
            if (this.tableModel.getRowCount() > 0) {
                GuiUtils.cancelEditing((JTable)this.jmsPropertiesTable);
                int rowSelected = this.jmsPropertiesTable.getSelectedRow();
                if (rowSelected != -1) {
                    this.tableModel.removeRow(rowSelected);
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() == 0) {
                        this.deleteButton.setEnabled(false);
                    } else {
                        int rowToSelect = rowSelected;
                        if (rowSelected >= this.tableModel.getRowCount()) {
                            rowToSelect = rowSelected - 1;
                        }
                        this.jmsPropertiesTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                    }
                }
            }
        } else if (action.equals(ADD_COMMAND)) {
            GuiUtils.stopTableEditing((JTable)this.jmsPropertiesTable);
            this.tableModel.addNewRow();
            this.tableModel.fireTableDataChanged();
            if (!this.deleteButton.isEnabled()) {
                this.deleteButton.setEnabled(true);
            }
            int rowToSelect = this.tableModel.getRowCount() - 1;
            this.jmsPropertiesTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    public JPanel createPropertiesPanel() {
        this.jmsPropertiesTable = new JTable(this.tableModel);
        JMeterUtils.applyHiDPI((JTable)this.jmsPropertiesTable);
        this.jmsPropertiesTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.jmsPropertiesTable.setSelectionMode(0);
        this.jmsPropertiesTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        TableColumn mechanismColumn = this.jmsPropertiesTable.getColumnModel().getColumn(2);
        mechanismColumn.setCellEditor(new TypeCellEditor());
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"jms_props")));
        panel.add(new JScrollPane(this.jmsPropertiesTable));
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        return buttonPanel;
    }

    private static class TypeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public TypeCellEditor() {
            super(new JComboBox<Object>(new Object[]{Boolean.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName()}));
        }
    }

    private static class InnerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4638155137475747946L;
        final JMSProperties jmsProperties = new JMSProperties();

        public void addNewRow() {
            this.jmsProperties.addJmsProperty(new JMSProperty("", "", String.class.getName()));
        }

        public void clearData() {
            this.jmsProperties.clear();
            this.fireTableDataChanged();
        }

        public void removeRow(int row) {
            this.jmsProperties.removeJmsProperty(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public int getRowCount() {
            return this.jmsProperties.getJmsPropertyCount();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "value";
                }
                case 2: {
                    return "jms_properties_type";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            JMSProperty property = this.jmsProperties.getJmsProperty(row);
            switch (column) {
                case 0: {
                    return property.getName();
                }
                case 1: {
                    return property.getValue();
                }
                case 2: {
                    return property.getType();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            JMSProperty property = this.jmsProperties.getJmsProperty(row);
            if (log.isDebugEnabled()) {
                log.debug("Setting jms property value: " + value);
            }
            switch (column) {
                case 0: {
                    property.setName((String)value);
                    break;
                }
                case 1: {
                    property.setValue((String)value);
                    break;
                }
                case 2: {
                    property.setType((String)value);
                    break;
                }
            }
        }
    }
}

