/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.jmeter.protocol.jms.sampler.MessageAdmin;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FixedQueueExecutor
implements QueueExecutor {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final MessageProducer producer;
    private final int timeout;
    private final boolean useReqMsgIdAsCorrelId;

    public FixedQueueExecutor(MessageProducer producer, int timeout, boolean useReqMsgIdAsCorrelId) {
        this.producer = producer;
        this.timeout = timeout;
        this.useReqMsgIdAsCorrelId = useReqMsgIdAsCorrelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendAndReceive(Message request) throws JMSException {
        MessageAdmin messageAdmin;
        String id = request.getJMSCorrelationID();
        if (id == null && !this.useReqMsgIdAsCorrelId) {
            throw new IllegalArgumentException("Correlation id is null. Set the JMSCorrelationID header.");
        }
        MessageAdmin admin = MessageAdmin.getAdmin();
        if (this.useReqMsgIdAsCorrelId) {
            messageAdmin = admin;
            synchronized (messageAdmin) {
                this.producer.send(request);
                id = request.getJMSMessageID();
                admin.putRequest(id, request);
            }
        } else {
            admin.putRequest(id, request);
            this.producer.send(request);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("wait for reply " + id + " started on " + System.currentTimeMillis());
            }
            messageAdmin = request;
            synchronized (messageAdmin) {
                request.wait(this.timeout);
            }
            if (log.isDebugEnabled()) {
                log.debug("done waiting for " + id + " ended on " + System.currentTimeMillis());
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupt exception caught", (Throwable)e);
        }
        return admin.get(id);
    }
}

