/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.gui.RowDetailDialog;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class HTTPFileArgsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private transient JTable table;
    private transient ObjectTableModel tableModel;
    private JButton add;
    private JButton browse;
    private JButton delete;
    private AbstractButton showDetail;
    private static final String ADD = "add";
    private static final String BROWSE = "browse";
    private static final String ADD_FROM_CLIPBOARD = "addFromClipboard";
    private static final String DELETE = "delete";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String FILEPATH = "send_file_filename_label";
    private static final String PARAMNAME = "send_file_param_name_label";
    private static final String MIMETYPE = "send_file_mime_label";
    private static final String CLIPBOARD_LINE_DELIMITERS = "\n";
    private static final String CLIPBOARD_ARG_DELIMITERS = "\t";
    private static final String DETAIL = "detail";

    public HTTPFileArgsPanel() {
        this.init();
    }

    private void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{FILEPATH, PARAMNAME, MIMETYPE}, HTTPFileArg.class, new Functor[]{new Functor("getPath"), new Functor("getParamName"), new Functor("getMimeType")}, new Functor[]{new Functor("setPath"), new Functor("setParamName"), new Functor("setMimeType")}, new Class[]{String.class, String.class, String.class});
    }

    public static boolean testFunctors() {
        HTTPFileArgsPanel instance = new HTTPFileArgsPanel();
        instance.initializeTableModel();
        return instance.tableModel.checkFunctors(null, instance.getClass());
    }

    public void modifyTestElement(TestElement testElement) {
        GuiUtils.stopTableEditing((JTable)this.table);
        if (testElement instanceof HTTPSamplerBase) {
            HTTPSamplerBase base = (HTTPSamplerBase)testElement;
            int rows = this.tableModel.getRowCount();
            Iterator modelData = this.tableModel.iterator();
            HTTPFileArg[] files = new HTTPFileArg[rows];
            int row = 0;
            while (modelData.hasNext()) {
                HTTPFileArg file = (HTTPFileArg)modelData.next();
                files[row++] = file;
            }
            base.setHTTPFiles(files);
        }
    }

    public boolean hasData() {
        return this.tableModel.iterator().hasNext();
    }

    public void configure(TestElement testElement) {
        if (testElement instanceof HTTPSamplerBase) {
            HTTPSamplerBase base = (HTTPSamplerBase)testElement;
            this.tableModel.clearData();
            for (HTTPFileArg file : base.getHTTPFiles()) {
                this.tableModel.addRow((Object)file);
            }
            this.checkButtonsStatus();
        }
    }

    private void checkButtonsStatus() {
        boolean hasRows = this.tableModel.getRowCount() > 0;
        this.browse.setEnabled(hasRows);
        this.delete.setEnabled(hasRows);
        this.showDetail.setEnabled(hasRows);
    }

    public void clear() {
        GuiUtils.stopTableEditing((JTable)this.table);
        this.tableModel.clearData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ADD)) {
            this.addFile("");
        } else if (action.equals(ADD_FROM_CLIPBOARD)) {
            this.addFromClipboard();
        } else if (action.equals(UP)) {
            this.moveUp();
        } else if (action.equals(DOWN)) {
            this.moveDown();
        } else if (action.equals(DETAIL)) {
            this.showDetail();
        }
        this.runCommandOnSelectedFile(action);
    }

    private void runCommandOnSelectedFile(String command) {
        GuiUtils.cancelEditing((JTable)this.table);
        int rowSelected = this.table.getSelectedRow();
        if (rowSelected >= 0) {
            this.runCommandOnRow(command, rowSelected);
            this.tableModel.fireTableDataChanged();
            this.checkButtonsStatus();
            if (this.tableModel.getRowCount() != 0) {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    private void runCommandOnRow(String command, int rowSelected) {
        String path;
        if (DELETE.equals(command)) {
            this.tableModel.removeRow(rowSelected);
        } else if (BROWSE.equals(command) && StringUtils.isNotBlank((CharSequence)(path = HTTPFileArgsPanel.browseAndGetFilePath()))) {
            this.tableModel.setValueAt((Object)path, rowSelected, 0);
        }
    }

    private void addFile(String path) {
        GuiUtils.stopTableEditing((JTable)this.table);
        this.tableModel.addRow((Object)new HTTPFileArg(path));
        this.checkButtonsStatus();
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    private static String browseAndGetFilePath() {
        File file;
        String path = "";
        JFileChooser chooser = FileDialoger.promptToOpenFile();
        if (chooser != null && (file = chooser.getSelectedFile()) != null) {
            path = file.getPath();
        }
        return path;
    }

    protected void stopTableEditing() {
        GuiUtils.stopTableEditing((JTable)this.table);
    }

    private Component makeMainPanel() {
        this.initializeTableModel();
        this.table = new JTable((TableModel)this.tableModel);
        JMeterUtils.applyHiDPI((JTable)this.table);
        this.table.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(0);
        return HTTPFileArgsPanel.makeScrollPane(this.table);
    }

    private JPanel makeButtonPanel() {
        this.add = new JButton(JMeterUtils.getResString((String)ADD));
        this.add.setActionCommand(ADD);
        this.add.setEnabled(true);
        this.browse = new JButton(JMeterUtils.getResString((String)BROWSE));
        this.browse.setActionCommand(BROWSE);
        this.delete = new JButton(JMeterUtils.getResString((String)DELETE));
        this.delete.setActionCommand(DELETE);
        this.showDetail = new JButton(JMeterUtils.getResString((String)DETAIL));
        this.showDetail.setActionCommand(DETAIL);
        this.showDetail.setEnabled(true);
        this.showDetail.addActionListener(this);
        JButton addFromClipboard = new JButton(JMeterUtils.getResString((String)"add_from_clipboard"));
        addFromClipboard.setActionCommand(ADD_FROM_CLIPBOARD);
        JButton up = new JButton(JMeterUtils.getResString((String)UP));
        up.setActionCommand(UP);
        JButton down = new JButton(JMeterUtils.getResString((String)DOWN));
        down.setActionCommand(DOWN);
        this.checkButtonsStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add.addActionListener(this);
        this.browse.addActionListener(this);
        addFromClipboard.addActionListener(this);
        this.delete.addActionListener(this);
        up.addActionListener(this);
        down.addActionListener(this);
        buttonPanel.add(this.showDetail);
        buttonPanel.add(this.add);
        buttonPanel.add(this.browse);
        buttonPanel.add(addFromClipboard);
        buttonPanel.add(this.delete);
        buttonPanel.add(up);
        buttonPanel.add(down);
        return buttonPanel;
    }

    private void init() {
        HTTPFileArgsPanel p = this;
        p.setLayout(new BorderLayout());
        p.add(this.makeMainPanel(), "Center");
        p.add(Box.createVerticalStrut(70), "West");
        p.add((Component)this.makeButtonPanel(), "South");
        this.table.revalidate();
    }

    private static JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return (JScrollPane)GuiUtils.emptyBorder((JComponent)pane);
    }

    private void moveDown() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing((JTable)this.table);
        if (rowsSelected.length > 0 && rowsSelected[rowsSelected.length - 1] < this.table.getRowCount() - 1) {
            this.table.clearSelection();
            for (int i = rowsSelected.length - 1; i >= 0; --i) {
                int rowSelected = rowsSelected[i];
                this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected + 1);
            }
            for (int rowSelected : rowsSelected) {
                this.table.addRowSelectionInterval(rowSelected + 1, rowSelected + 1);
            }
            this.scrollToRowIfNotVisible(rowsSelected[0] + 1);
        }
    }

    private void scrollToRowIfNotVisible(int rowIndex) {
        if (this.table.getParent() instanceof JViewport) {
            Rectangle visibleRect = this.table.getVisibleRect();
            boolean cellIndex = false;
            Rectangle cellRect = this.table.getCellRect(rowIndex, 0, false);
            if (visibleRect.y > cellRect.y) {
                this.table.scrollRectToVisible(cellRect);
            } else {
                Rectangle rect2 = this.table.getCellRect(rowIndex + HTTPFileArgsPanel.getNumberOfVisibleRows(this.table), 0, true);
                int width = rect2.y - cellRect.y;
                this.table.scrollRectToVisible(new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height + width));
            }
        }
    }

    private static int getNumberOfVisibleRows(JTable table) {
        Rectangle vr = table.getVisibleRect();
        int first = table.rowAtPoint(vr.getLocation());
        vr.translate(0, vr.height);
        return table.rowAtPoint(vr.getLocation()) - first;
    }

    private void moveUp() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing((JTable)this.table);
        if (rowsSelected.length > 0 && rowsSelected[0] > 0) {
            this.table.clearSelection();
            for (int rowSelected : rowsSelected) {
                this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected - 1);
            }
            for (int rowSelected : rowsSelected) {
                this.table.addRowSelectionInterval(rowSelected - 1, rowSelected - 1);
            }
            this.scrollToRowIfNotVisible(rowsSelected[0] - 1);
        }
    }

    private void addFromClipboard() {
        this.addFromClipboard(CLIPBOARD_LINE_DELIMITERS, CLIPBOARD_ARG_DELIMITERS);
    }

    private void addFromClipboard(String lineDelimiter, String argDelimiter) {
        GuiUtils.stopTableEditing((JTable)this.table);
        int rowCount = this.table.getRowCount();
        try {
            String[] clipboardLines;
            String clipboardContent = GuiUtils.getPastedText();
            if (clipboardContent == null) {
                return;
            }
            for (String clipboardLine : clipboardLines = clipboardContent.split(lineDelimiter)) {
                HTTPFileArg argument;
                String[] clipboardCols = clipboardLine.split(argDelimiter);
                if (clipboardCols.length <= 0 || (argument = HTTPFileArgsPanel.createHTTPFileArgFromClipboard(clipboardCols)) == null) continue;
                this.tableModel.addRow((Object)argument);
            }
            if (this.table.getRowCount() > rowCount) {
                this.checkButtonsStatus();
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.table.setRowSelectionInterval(rowCount, rowToSelect);
                this.table.scrollRectToVisible(this.table.getCellRect(rowCount, 0, true));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Could not add read file arguments from clipboard:\n" + ioe.getLocalizedMessage(), "Error", 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog(this, "Could not add retrieve " + DataFlavor.stringFlavor.getHumanPresentableName() + " from clipboard" + ufe.getLocalizedMessage(), "Error", 0);
        }
    }

    private static HTTPFileArg createHTTPFileArgFromClipboard(String[] clipboardCols) {
        if (clipboardCols.length == 1) {
            return new HTTPFileArg(clipboardCols[0]);
        }
        if (clipboardCols.length == 2) {
            return new HTTPFileArg(clipboardCols[0], clipboardCols[1], "");
        }
        if (clipboardCols.length == 3) {
            return new HTTPFileArg(clipboardCols[0], clipboardCols[1], clipboardCols[2]);
        }
        return null;
    }

    private void showDetail() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing((JTable)this.table);
        if (rowsSelected.length == 1) {
            this.table.clearSelection();
            RowDetailDialog detailDialog = new RowDetailDialog(this.tableModel, rowsSelected[0]);
            detailDialog.setVisible(true);
        }
    }
}

