/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShell
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(BeanShell.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__BeanShell";
    public static final String INIT_FILE = "beanshell.function.init";
    private Object[] values;
    private BeanShellInterpreter bshInterpreter = null;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        if (this.bshInterpreter == null) {
            throw new InvalidVariableException("BeanShell not found");
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        String script = ((CompoundVariable)this.values[0]).execute();
        String varName = "";
        if (this.values.length > 1) {
            varName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        String resultStr = "";
        try {
            if (currentSampler != null) {
                this.bshInterpreter.set("Sampler", (Object)currentSampler);
            }
            if (previousResult != null) {
                this.bshInterpreter.set("SampleResult", (Object)previousResult);
            }
            this.bshInterpreter.set("ctx", (Object)jmctx);
            this.bshInterpreter.set("vars", (Object)vars);
            this.bshInterpreter.set("props", (Object)JMeterUtils.getJMeterProperties());
            this.bshInterpreter.set("threadName", (Object)Thread.currentThread().getName());
            Object bshOut = this.bshInterpreter.eval(script);
            if (bshOut != null) {
                resultStr = bshOut.toString();
            }
            if (vars != null && varName.length() > 0) {
                vars.put(varName, resultStr);
            }
        }
        catch (Exception ex) {
            log.warn("Error running BSH script", (Throwable)ex);
        }
        log.debug("__Beanshell({},{})={}", new Object[]{script, varName, resultStr});
        return resultStr;
    }

    public void log_info(String s) {
        log.info(s);
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
        try {
            this.bshInterpreter = new BeanShellInterpreter(JMeterUtils.getProperty((String)INIT_FILE), log);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidVariableException("BeanShell not found", (Throwable)e);
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"bsh_function_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

