/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Perl5Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeOroRegexpChars
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(EscapeOroRegexpChars.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__escapeOroRegexpChars";
    private CompoundVariable[] values;
    private static final int MAX_PARAM_COUNT = 2;
    private static final int MIN_PARAM_COUNT = 1;
    private static final int PARAM_NAME = 2;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String valueToEscape = this.values[0].execute();
        String varName = "";
        if (this.values.length >= 2) {
            varName = this.values[1].execute().trim();
        }
        String escapedValue = Perl5Compiler.quotemeta((String)valueToEscape);
        if (varName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(varName, escapedValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} name:{} value:{}", new Object[]{Thread.currentThread().getName(), varName, escapedValue});
        }
        return escapedValue;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"value_to_quote_meta"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

