/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JSR223TestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Groovy
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(Groovy.class);
    private static final String GROOVY_ENGINE_NAME = "groovy";
    private static final List<String> DESCRIPTION = new LinkedList<String>();
    private static final String KEY = "__groovy";
    public static final String INIT_FILE = "groovy.utilities";
    private Object[] values;
    private ScriptEngine scriptEngine;

    protected void populateBindings(Bindings bindings) {
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        Bindings bindings = this.scriptEngine.createBindings();
        this.populateBindings(bindings);
        String script = ((CompoundVariable)this.values[0]).execute();
        String varName = "";
        if (this.values.length > 1) {
            varName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        String resultStr = "";
        try {
            if (currentSampler != null) {
                bindings.put("sampler", (Object)currentSampler);
            }
            if (previousResult != null) {
                bindings.put("prev", (Object)previousResult);
            }
            bindings.put("log", (Object)log);
            bindings.put("threadName", (Object)Thread.currentThread().getName());
            JMeterContext jmctx = JMeterContextService.getContext();
            bindings.put("ctx", (Object)jmctx);
            JMeterVariables vars = jmctx.getVariables();
            bindings.put("vars", (Object)vars);
            Properties props = JMeterUtils.getJMeterProperties();
            bindings.put("props", (Object)props);
            bindings.put("OUT", (Object)System.out);
            Object out = this.scriptEngine.eval(script, bindings);
            if (out != null) {
                resultStr = out.toString();
            }
            if (varName.length() > 0 && vars != null) {
                vars.put(varName, resultStr);
            }
        }
        catch (Exception ex) {
            log.warn("Error running groovy script", (Throwable)ex);
        }
        log.debug("__groovy({},{})={}", new Object[]{script, varName, resultStr});
        return resultStr;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
        this.scriptEngine = JSR223TestElement.getInstance().getEngineByName(GROOVY_ENGINE_NAME);
        String fileName = JMeterUtils.getProperty((String)INIT_FILE);
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            File file = new File(fileName);
            if (!file.exists() || !file.canRead()) {
                File oldFile = file;
                file = new File(JMeterUtils.getJMeterHome(), fileName);
                if (!file.exists() || !file.canRead()) {
                    throw new InvalidVariableException("Cannot read file, neither from:" + oldFile.getAbsolutePath() + ", nor from:" + file.getAbsolutePath() + ", check property '" + INIT_FILE + "'");
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());){
                Bindings bindings = this.scriptEngine.createBindings();
                bindings.put("log", (Object)log);
                this.scriptEngine.eval((Reader)reader, bindings);
            }
            catch (Exception ex) {
                throw new InvalidVariableException("Failed loading script:" + file.getAbsolutePath(), (Throwable)ex);
            }
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return DESCRIPTION;
    }

    static {
        DESCRIPTION.add(JMeterUtils.getResString((String)"groovy_function_expression"));
        DESCRIPTION.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

