/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationCounter
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__counter";
    private ThreadLocal<Integer> perThreadInt;
    private Object[] variables;
    private int globalCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        IterationCounter iterationCounter = this;
        synchronized (iterationCounter) {
            this.globalCounter = 0;
        }
        this.perThreadInt = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    public IterationCounter() {
        this.init();
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        ++this.globalCounter;
        JMeterVariables vars = this.getVariables();
        boolean perThread = Boolean.valueOf(((CompoundVariable)this.variables[0]).execute());
        String varName = "";
        if (this.variables.length >= 2) {
            varName = ((CompoundVariable)this.variables[1]).execute().trim();
        }
        String counterString = "";
        if (perThread) {
            int threadCounter = this.perThreadInt.get() + 1;
            this.perThreadInt.set(threadCounter);
            counterString = String.valueOf(threadCounter);
        } else {
            counterString = String.valueOf(this.globalCounter);
        }
        if (vars != null && varName.length() > 0) {
            vars.put(varName, counterString);
        }
        return counterString;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.variables = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"iteration_counter_arg_1"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

