/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class Random
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__Random";
    private CompoundVariable varName;
    private CompoundVariable minimum;
    private CompoundVariable maximum;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        long min = Long.parseLong(this.minimum.execute().trim());
        long max = Long.parseLong(this.maximum.execute().trim());
        long rand = min + (long)(Math.random() * (double)(max - min + 1L));
        String randString = Long.toString(rand);
        if (this.varName != null) {
            JMeterVariables vars = this.getVariables();
            String varTrim = this.varName.execute().trim();
            if (vars != null && varTrim.length() > 0) {
                vars.put(varTrim, randString);
            }
        }
        return randString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 3);
        Object[] values = parameters.toArray();
        this.minimum = (CompoundVariable)values[0];
        this.maximum = (CompoundVariable)values[1];
        this.varName = values.length > 2 ? (CompoundVariable)values[2] : null;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"minimum_param"));
        desc.add(JMeterUtils.getResString((String)"maximum_param"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

