/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.functions.LogFunction;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LogFunction2
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__logn";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 3;
    private static final String DEFAULT_PRIORITY = "INFO";
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String priorityString;
        String stringToLog = ((CompoundVariable)this.values[0]).execute();
        if (this.values.length > 1) {
            priorityString = ((CompoundVariable)this.values[1]).execute();
            if (priorityString.length() == 0) {
                priorityString = DEFAULT_PRIORITY;
            }
        } else {
            priorityString = DEFAULT_PRIORITY;
        }
        Throwable t = null;
        if (this.values.length > 2) {
            t = new Throwable(((CompoundVariable)this.values[2]).execute());
        }
        LogFunction.logDetails(log, stringToLog, priorityString, t, "");
        return "";
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"log_function_string"));
        desc.add(JMeterUtils.getResString((String)"log_function_level"));
        desc.add(JMeterUtils.getResString((String)"log_function_throwable"));
    }
}

