/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.ConstantThroughputTimerBeanInfo;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ConstantThroughputTimer
extends AbstractTestElement
implements Timer,
TestListener,
TestBean {
    private static final long serialVersionUID = 3L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final double MILLISEC_PER_MIN = 60000.0;
    private long previousTime = 0L;
    private String calcMode;
    private int modeInt;
    private double throughput;
    private static final ThroughputInfo allThreadsInfo = new ThroughputInfo();
    private static final ConcurrentMap<AbstractThreadGroup, ThroughputInfo> threadGroupsInfoMap = new ConcurrentHashMap<AbstractThreadGroup, ThroughputInfo>();

    public void setThroughput(double throughput) {
        this.throughput = throughput;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public String getCalcMode() {
        return this.calcMode;
    }

    int getCalcModeInt() {
        return this.modeInt;
    }

    public void setCalcMode(String mode) {
        this.calcMode = mode;
        this.modeInt = ConstantThroughputTimerBeanInfo.getCalcModeAsInt(this.calcMode);
    }

    public long delay() {
        long currentTarget;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (currentTarget = this.previousTime + this.calculateDelay())) {
            this.previousTime = currentTime;
            return 0L;
        }
        this.previousTime = currentTarget;
        return currentTarget - currentTime;
    }

    protected long calculateCurrentTarget(long currentTime) {
        return currentTime + this.calculateDelay();
    }

    private long calculateDelay() {
        long delay = 0L;
        double msPerRequest = 60000.0 / this.getThroughput();
        switch (this.modeInt) {
            case 1: {
                delay = (long)((double)JMeterContextService.getNumberOfThreads() * msPerRequest);
                break;
            }
            case 2: {
                delay = (long)((double)JMeterContextService.getContext().getThreadGroup().getNumberOfThreads() * msPerRequest);
                break;
            }
            case 3: {
                delay = this.calculateSharedDelay(allThreadsInfo, (long)msPerRequest);
                break;
            }
            case 4: {
                ThroughputInfo previous;
                AbstractThreadGroup group = JMeterContextService.getContext().getThreadGroup();
                ThroughputInfo groupInfo = (ThroughputInfo)threadGroupsInfoMap.get(group);
                if (groupInfo == null && (previous = threadGroupsInfoMap.putIfAbsent(group, groupInfo = new ThroughputInfo())) != null) {
                    groupInfo = previous;
                }
                delay = this.calculateSharedDelay(groupInfo, (long)msPerRequest);
                break;
            }
            default: {
                delay = (long)msPerRequest;
            }
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateSharedDelay(ThroughputInfo info, long milliSecPerRequest) {
        long calculatedDelay;
        long now = System.currentTimeMillis();
        Object object = info.MUTEX;
        synchronized (object) {
            long nextRequstTime = info.lastScheduledTime + milliSecPerRequest;
            info.lastScheduledTime = Math.max(now, nextRequstTime);
            calculatedDelay = info.lastScheduledTime - now;
        }
        return Math.max(calculatedDelay, 0L);
    }

    private synchronized void reset() {
        ConstantThroughputTimer.allThreadsInfo.lastScheduledTime = 0L;
        threadGroupsInfoMap.clear();
        this.previousTime = 0L;
    }

    public String toString() {
        return JMeterUtils.getResString((String)"constant_throughput_timer_memo");
    }

    public void testStarted() {
        log.debug("Test started - reset throughput calculation.");
        this.reset();
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    private static class ThroughputInfo {
        final Object MUTEX = new Object();
        long lastScheduledTime = 0L;

        private ThroughputInfo() {
        }
    }
}

