/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final char NEW_LINE = '\n';
    private static final ThreadLocal<SAXBuilder> myBuilder = new ThreadLocal<SAXBuilder>(){

        @Override
        protected SAXBuilder initialValue() {
            return new SAXBuilder();
        }
    };

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        byte[] responseData = response.getResponseData();
        if (responseData.length == 0) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        String resultData = new String(this.getResultBody(responseData));
        SAXBuilder builder = myBuilder.get();
        try {
            builder.build((Reader)new StringReader(resultData));
        }
        catch (JDOMException e) {
            log.debug("Cannot parse result content", (Throwable)e);
            result.setFailure(true);
            result.setFailureMessage(e.getMessage());
        }
        catch (IOException e) {
            log.error("Cannot read result content", (Throwable)e);
            result.setError(true);
            result.setFailureMessage(e.getMessage());
        }
        return result;
    }

    private byte[] getResultBody(byte[] resultData) {
        for (int i = 0; i < resultData.length - 1; ++i) {
            if (resultData[i] != 10 || resultData[i + 1] != 10) continue;
            return this.getByteArraySlice(resultData, i + 2, resultData.length - 1);
        }
        return resultData;
    }

    private byte[] getByteArraySlice(byte[] array, int begin, int end) {
        byte[] slice = new byte[end - begin + 1];
        int count = 0;
        for (int i = begin; i <= end; ++i) {
            slice[count] = array[i];
            ++count;
        }
        return slice;
    }
}

