/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphAccum;
import org.apache.jmeter.visualizers.GraphAccumListener;
import org.apache.jmeter.visualizers.GraphAccumModel;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GraphAccumVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
GraphAccumListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected transient GraphAccumModel model = new GraphAccumModel();
    protected transient GraphAccum graph;
    protected transient JPanel legendPanel;

    public GraphAccumVisualizer() {
        this.model.addGraphAccumListener(this);
        this.init();
        log.debug("Start : GraphAccumVisualizer1");
        log.debug("End : GraphAccumVisualizer1");
    }

    public String getLabelResource() {
        return "graph_full_results_title";
    }

    public void add(SampleResult res) {
        this.model.addNewSample(res);
    }

    public Object getWhiteCanvas() {
        return this.legendPanel;
    }

    public Image getImage() {
        log.debug("Start : getImage1");
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        log.debug("End : getImage1");
        return result;
    }

    public void updateGui() {
        log.debug("Start : updateGui1");
        this.graph.updateGui();
        log.debug("End : updateGui1");
    }

    public void updateGui(SampleResult s) {
        log.debug("Start : updateGui2");
        log.debug("End : updateGui2");
    }

    public synchronized void clearData() {
        this.model.clearData();
        this.graph.clearData();
        log.debug("Start : clear1");
        this.repaint();
        log.debug("End : clear1");
    }

    public String toString() {
        String toString = "Show the samples analysys as dot plots";
        return toString;
    }

    private void init() {
        log.debug("Start : init1");
        this.graph = new GraphAccum(this.model);
        this.graph.setVisualizer(this);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"graph_full_results_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        mainPanel.add(this.getFilePanel());
        JScrollPane graphScrollPanel = new JScrollPane(this.graph, 21, 30);
        graphScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.legendPanel = new JPanel();
        JScrollPane legendScrollPanel = new JScrollPane(this.legendPanel);
        JSplitPane graphSplitPane = new JSplitPane(0, graphScrollPanel, legendScrollPanel);
        this.add(mainPanel, "North");
        this.add(graphSplitPane, "Center");
        log.debug("End : init1");
    }
}

