/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.query.text.changes.ChangesBatched;
import org.apache.jena.query.text.changes.TextQuadAction;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDocProducerEntities
extends ChangesBatched
implements TextDocProducer {
    private static Logger log = LoggerFactory.getLogger(TextDocProducer.class);
    private final EntityDefinition defn;
    private final TextIndex indexer;
    private final ThreadLocal<Boolean> inTransaction = new ThreadLocal<Boolean>(this){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public TextDocProducerEntities(TextIndex indexer) {
        this.defn = indexer.getDocDef();
        this.indexer = indexer;
        this.inTransaction.set(false);
    }

    @Override
    protected void startBatched() {
        this.inTransaction.set(true);
    }

    @Override
    protected void finishBatched() {
        this.inTransaction.set(false);
    }

    @Override
    protected void dispatch(TextQuadAction quadAction, List<Quad> batch) {
        if (!this.inTransaction.get().booleanValue()) {
            throw new IllegalStateException("Not started");
        }
        if (!TextQuadAction.ADD.equals((Object)quadAction)) {
            return;
        }
        if (batch.size() == 0) {
            return;
        }
        this.docQuads(batch);
    }

    private void docEntity(Node g, Node s, List<Quad> batch) {
        String x = TextQueryFuncs.subjectToString(s);
        String gx = TextQueryFuncs.graphNodeToString(g);
        Entity entity = new Entity(x, gx);
        String graphField = this.defn.getGraphField();
        if (this.defn.getGraphField() != null) {
            entity.put(graphField, gx);
        }
        for (Quad quad : batch) {
            Node p = quad.getPredicate();
            String field = this.defn.getField(p);
            if (field == null) continue;
            Node o = quad.getObject();
            String val = null;
            if (o.isURI()) {
                val = o.getURI();
            } else if (o.isLiteral()) {
                val = o.getLiteralLexicalForm();
            } else {
                log.warn("Not a literal value for mapped field-predicate: " + field + " :: " + FmtUtils.stringForString((String)field));
                continue;
            }
            entity.put(field, val);
        }
        this.indexer.addEntity(entity);
    }

    private void docQuads(List<Quad> batch) {
        for (Quad quad : batch) {
            Entity entity = TextQueryFuncs.entityFromQuad(this.defn, quad);
            if (entity == null) continue;
            this.indexer.addEntity(entity);
        }
    }
}

