/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.pfunction;

import java.util.List;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialValueUtil;
import org.apache.jena.query.spatial.pfunction.SpatialMatch;
import org.apache.jena.query.spatial.pfunction.SpatialOperationPFBase;
import org.apache.jena.query.spatial.pfunction.SpatialOperationWithCircleBase;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialOperationWithBoxPFBase
extends SpatialOperationPFBase {
    private static Logger log = LoggerFactory.getLogger(SpatialOperationWithCircleBase.class);

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (!argSubject.isNode()) {
            throw new QueryBuildException("Subject is not a single node: " + argSubject);
        }
        if (argObject.isList()) {
            List list = argObject.getArgList();
            if (list.size() < 4) {
                throw new QueryBuildException("Not enough arguments in list");
            }
            if (list.size() > 5) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
        }
    }

    @Override
    protected SpatialMatch objectToStruct(PropFuncArg argObject) {
        if (argObject.isNode()) {
            log.warn("Object not a List: " + argObject);
            return null;
        }
        List list = argObject.getArgList();
        if (list.size() < 4 || list.size() > 5) {
            throw new SpatialIndexException("Change in object list size");
        }
        int idx = 0;
        Node x = (Node)list.get(idx);
        if (!x.isLiteral()) {
            log.warn("Latitude 1 is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x)) {
            log.warn("Latitude 1 is not a decimal " + list);
            return null;
        }
        Double latitude1 = Double.parseDouble(x.getLiteralLexicalForm());
        if (!(x = (Node)list.get(++idx)).isLiteral()) {
            log.warn("Longitude 1 is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x)) {
            log.warn("Longitude 1 is not a decimal " + list);
            return null;
        }
        Double longtitude1 = Double.parseDouble(x.getLiteralLexicalForm());
        if (!(x = (Node)list.get(++idx)).isLiteral()) {
            log.warn("Latitude 2 is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x)) {
            log.warn("Latitude 2 is not a decimal " + list);
            return null;
        }
        Double latitude2 = Double.parseDouble(x.getLiteralLexicalForm());
        if (!(x = (Node)list.get(++idx)).isLiteral()) {
            log.warn("Longitude 2 is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x)) {
            log.warn("Longitude 2 is not a decimal " + list);
            return null;
        }
        Double longtitude2 = Double.parseDouble(x.getLiteralLexicalForm());
        int limit = -1;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            if (!x.isLiteral()) {
                log.warn("Limit is not a literal " + list);
                return null;
            }
            LiteralLabel lit = x.getLiteral();
            if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                log.warn("Limit is not an integer " + list);
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            int n = limit = v < 0 ? -1 : v;
            if (++idx < list.size()) {
                log.warn("Limit is not the last parameter " + list);
                return null;
            }
        }
        SpatialMatch match = new SpatialMatch(latitude1, longtitude1, latitude2, longtitude2, limit, this.getSpatialOperation());
        if (log.isDebugEnabled()) {
            log.debug("Trying SpatialMatch: " + match.toString());
        }
        return match;
    }
}

