/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.sparql.util.NodeUtils;

public class SpatialValueUtil {
    public static boolean isDecimal(Node n) {
        if (NodeUtils.isSimpleString((Node)n) || NodeUtils.isLangString((Node)n)) {
            try {
                Double.parseDouble(n.getLiteralLexicalForm());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        RDFDatatype dtype = n.getLiteralDatatype();
        return dtype.equals(XSDDatatype.XSDfloat) || dtype.equals(XSDDatatype.XSDdecimal) || dtype.equals(XSDDatatype.XSDdouble) || dtype.equals(XSDDatatype.XSDinteger);
    }

    public static boolean isWKTLiteral(LiteralLabel literal) {
        RDFDatatype dtype = literal.getDatatype();
        if (dtype == null) {
            return false;
        }
        return dtype.getURI().equals(EntityDefinition.geosparql_wktLiteral.getURI());
    }
}

