/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.pfunction;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.util.List;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialValueUtil;
import org.apache.jena.query.spatial.pfunction.SpatialMatch;
import org.apache.jena.query.spatial.pfunction.SpatialOperationPFBase;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectionWithPointPFBase
extends SpatialOperationPFBase {
    private static Logger log = LoggerFactory.getLogger(DirectionWithPointPFBase.class);

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (!argSubject.isNode()) {
            throw new QueryBuildException("Subject is not a single node: " + argSubject);
        }
        if (argObject.isList()) {
            List list = argObject.getArgList();
            if (list.size() < 2) {
                throw new QueryBuildException("Not enough arguments in list");
            }
            if (list.size() > 3) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
        }
    }

    @Override
    protected SpatialMatch objectToStruct(PropFuncArg argObject) {
        if (argObject.isNode()) {
            log.warn("Object not a List: " + argObject);
            return null;
        }
        List list = argObject.getArgList();
        if (list.size() < 2 || list.size() > 3) {
            throw new SpatialIndexException("Change in object list size");
        }
        int idx = 0;
        Node x = (Node)list.get(idx);
        if (!x.isLiteral()) {
            log.warn("Latitude is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x.getLiteral())) {
            log.warn("Latitude is not a decimal " + list);
            return null;
        }
        Double latitude = Double.parseDouble(x.getLiteralLexicalForm());
        if (!(x = (Node)list.get(++idx)).isLiteral()) {
            log.warn("Longitude is not a literal " + list);
            return null;
        }
        if (!SpatialValueUtil.isDecimal(x.getLiteral())) {
            log.warn("Longitude is not a decimal " + list);
            return null;
        }
        Double longitude = Double.parseDouble(x.getLiteralLexicalForm());
        int limit = -1;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            if (!x.isLiteral()) {
                log.warn("Limit is not a literal " + list);
                return null;
            }
            LiteralLabel lit = x.getLiteral();
            if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                log.warn("Limit is not an integer " + list);
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            int n = limit = v < 0 ? -1 : v;
            if (++idx < list.size()) {
                log.warn("Limit is not the last parameter " + list);
                return null;
            }
        }
        SpatialMatch match = this.getSpatialMatch(latitude, longitude, limit);
        if (log.isDebugEnabled()) {
            log.debug("Trying SpatialMatch: " + match.toString());
        }
        return match;
    }

    protected abstract SpatialMatch getSpatialMatch(Double var1, Double var2, int var3);

    @Override
    protected SpatialOperation getSpatialOperation() {
        return SpatialOperation.IsWithin;
    }
}

