/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class QuadCollectionHolder
implements QuadHolder {
    private final List<Quad> collection = new ArrayList<Quad>();
    private Map<Var, Node> values;

    public QuadCollectionHolder(Collection<Quad> quads) {
        this.collection.addAll(quads);
    }

    public QuadCollectionHolder(Iterator<Quad> quads) {
        quads.forEachRemaining(this.collection::add);
    }

    private Node valueMap(Node n) {
        if (n.isVariable()) {
            Var v = Var.alloc((Node)n);
            return this.values.getOrDefault(v, n);
        }
        return n;
    }

    @Override
    public ExtendedIterator<Quad> getQuads() {
        ExtendedIterator retval = WrappedIterator.create(this.collection.iterator());
        if (this.values != null) {
            retval = retval.mapWith(q -> new Quad(this.valueMap(q.getGraph()), this.valueMap(q.getSubject()), this.valueMap(q.getPredicate()), this.valueMap(q.getObject())));
        }
        return retval;
    }

    @Override
    public QuadHolder setValues(Map<Var, Node> values) {
        this.values = values;
        return this;
    }
}

