/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.lang.reflect.InvocationTargetException;
import java.util.function.BiFunction;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.vocabulary.RDF;

public interface EnhNodeProducer {
    public EnhNode newInstance(Node var1, EnhGraph var2);

    public void doInsert(Node var1, EnhGraph var2);

    public boolean canInsert(Node var1, EnhGraph var2);

    public String targetName();

    default public EnhNodeProducer restrict(final EnhNodeFilter filter) {
        OntJenaException.notNull(filter, "Null restriction filter.");
        return new EnhNodeProducer(){

            @Override
            public void doInsert(Node node, EnhGraph eg) {
                EnhNodeProducer.this.doInsert(node, eg);
            }

            @Override
            public boolean canInsert(Node node, EnhGraph eg) {
                return EnhNodeProducer.this.canInsert(node, eg) && filter.test(node, eg);
            }

            @Override
            public EnhNode newInstance(Node node, EnhGraph eg) {
                return EnhNodeProducer.this.newInstance(node, eg);
            }

            @Override
            public String targetName() {
                return EnhNodeProducer.this.targetName();
            }

            public String toString() {
                return "Producer[" + this.targetName() + "]Restriction[" + filter + "]";
            }
        };
    }

    public static class WithType
    extends Default {
        protected final Node type;

        public WithType(Class<? extends OntObjectImpl> impl, Resource type, BiFunction<Node, EnhGraph, EnhNode> producer) {
            super(impl, producer);
            this.type = OntJenaException.notNull(type, "Null type.").asNode();
        }

        public WithType(Class<? extends OntObjectImpl> impl, Resource type) {
            super(impl);
            this.type = OntJenaException.notNull(type, "Null type.").asNode();
        }

        @Override
        public void doInsert(Node node, EnhGraph eg) {
            eg.asGraph().add(Triple.create((Node)node, (Node)RDF.type.asNode(), (Node)this.type));
        }

        @Override
        public boolean canInsert(Node node, EnhGraph eg) {
            return true;
        }
    }

    public static class Default
    implements EnhNodeProducer {
        private final BiFunction<Node, EnhGraph, EnhNode> producer;
        private final String targetName;

        public Default(Class<? extends EnhNode> impl, BiFunction<Node, EnhGraph, EnhNode> producer) {
            this.targetName = OntJenaException.notNull(impl, "Null implementation class.").getName().replace(impl.getPackageName() + ".", "");
            this.producer = OntJenaException.notNull(producer);
        }

        public Default(Class<? extends EnhNode> impl) {
            this.targetName = OntJenaException.notNull(impl, "Null implementation class.").getName().replace(impl.getPackageName() + ".", "");
            this.producer = (node, graph) -> Default.newInstance(node, graph, impl, this.targetName);
        }

        @Override
        public void doInsert(Node node, EnhGraph eg) {
            throw new OntJenaException.IllegalCall("Creation is not allowed for node " + node + " and target " + this.targetName());
        }

        @Override
        public boolean canInsert(Node node, EnhGraph eg) {
            return false;
        }

        @Override
        public EnhNode newInstance(Node node, EnhGraph eg) {
            return this.producer.apply(node, eg);
        }

        private static EnhNode newInstance(Node node, EnhGraph eg, Class<? extends EnhNode> impl, String targetName) {
            try {
                return impl.getDeclaredConstructor(Node.class, EnhGraph.class).newInstance(node, eg);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new OntJenaException("Can't create instance of " + targetName, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JenaException) {
                    throw (JenaException)e.getCause();
                }
                throw new OntJenaException("Can't init " + targetName, e);
            }
        }

        @Override
        public String targetName() {
            return this.targetName;
        }
    }
}

