/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.HierarchySupport;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntClassImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntIndividualImpl
extends OntObjectImpl
implements OntIndividual {
    public OntIndividualImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(RDFNode node) {
        if (OntJenaException.notNull(node, "Null node.").canAs(OntIndividual.Anonymous.class)) {
            return (OntIndividual.Anonymous)node.as(OntIndividual.Anonymous.class);
        }
        if (node.isAnon()) {
            return new AnonymousImpl(node.asNode(), (EnhGraph)node.getModel());
        }
        throw new OntJenaException.Conversion(node + " can't be presented as an anonymous individual");
    }

    @Override
    public Stream<OntClass> classes(boolean direct) {
        return OntIndividualImpl.classes(this, direct);
    }

    @Override
    public boolean hasOntClass(OntClass clazz, boolean direct) {
        Property reasonerProperty;
        if (direct && (reasonerProperty = OntIndividualImpl.reasonerProperty(this.getModel(), RDF.type)) != null) {
            return this.getModel().contains(this, reasonerProperty, (RDFNode)clazz);
        }
        AtomicBoolean isIndividual = new AtomicBoolean(true);
        return HierarchySupport.contains(this, clazz, it -> OntIndividualImpl.listClassesFor(it, isIndividual), direct, OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    @Override
    public Stream<OntIndividual> sameIndividuals() {
        if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_SAME_AS_FEATURE)) {
            return Stream.empty();
        }
        return this.objects(OWL2.sameAs, OntIndividual.class);
    }

    @Override
    public OntStatement addSameAsStatement(OntIndividual other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_SAME_AS_FEATURE, "owl:sameAs");
        return this.addStatement(OWL2.sameAs, (RDFNode)other);
    }

    @Override
    public OntIndividual removeSameIndividual(Resource other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_SAME_AS_FEATURE, "owl:sameAs");
        this.remove(OWL2.sameAs, (RDFNode)other);
        return this;
    }

    @Override
    public Stream<OntIndividual> differentIndividuals() {
        if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_DIFFERENT_FROM_FEATURE)) {
            return Stream.empty();
        }
        return this.objects(OWL2.differentFrom, OntIndividual.class);
    }

    @Override
    public OntStatement addDifferentFromStatement(OntIndividual other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_DIFFERENT_FROM_FEATURE, "owl:differentFrom");
        return this.addStatement(OWL2.differentFrom, (RDFNode)other);
    }

    @Override
    public OntIndividual removeDifferentIndividual(Resource other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_INDIVIDUAL_DIFFERENT_FROM_FEATURE, "owl:differentFrom");
        this.remove(OWL2.differentFrom, (RDFNode)other);
        return this;
    }

    public ExtendedIterator<OntClass> listClasses() {
        return this.listObjects(RDF.type, OntClass.class);
    }

    static Stream<OntClass> classes(OntObject individual, boolean direct) {
        Property reasonerProperty;
        if (direct && (reasonerProperty = OntIndividualImpl.reasonerProperty(individual.getModel(), RDF.type)) != null) {
            return individual.objects(reasonerProperty, OntClass.class).filter(OntClass::canAsAssertionClass).map(OntClass::asAssertionClass);
        }
        AtomicBoolean isIndividual = new AtomicBoolean(true);
        Stream<OntObject> res = HierarchySupport.treeNodes(individual, it -> OntIndividualImpl.listClassesFor(it, isIndividual), direct, OntGraphModelImpl.configValue(individual.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
        return res.filter(OntClass::canAsAssertionClass).map(OntClass::asAssertionClass);
    }

    static Stream<OntClass> listClassesFor(OntObject resource, AtomicBoolean isFirstLevel) {
        if (isFirstLevel.get()) {
            isFirstLevel.set(false);
            return resource.objects(RDF.type, OntClass.class).filter(OntClass::canAsAssertionClass).map(OntClass::asAssertionClass);
        }
        return OntClassImpl.explicitSuperClasses(RDFS.subClassOf, resource);
    }

    @Override
    public boolean isLocal() {
        Optional<OntStatement> root = this.findRootStatement();
        return root.isPresent() && root.get().isLocal() || this.hasLocalClassAssertions();
    }

    protected boolean hasLocalClassAssertions() {
        return Iterators.findFirst(this.listClassAssertions().filterKeep(OntStatement::isLocal)).isPresent();
    }

    public ExtendedIterator<OntStatement> listClassAssertions() {
        return this.listStatements(RDF.type).filterKeep(s -> s.getObject().canAs(OntClass.class));
    }

    @Override
    public Stream<OntNegativeAssertion> negativeAssertions() {
        return Iterators.asStream(this.listNegativeAssertions(), this.getCharacteristics());
    }

    public ExtendedIterator<OntNegativeAssertion> listNegativeAssertions() {
        return this.listSubjects(OWL2.sourceIndividual, OntNegativeAssertion.class);
    }

    @Override
    protected Set<OntStatement> getContent() {
        Set<OntStatement> res = super.getContent();
        this.listNegativeAssertions().forEachRemaining(x -> res.addAll(((OntObjectImpl)((Object)x)).getContent()));
        return res;
    }

    public static class AnonymousImpl
    extends OntIndividualImpl
    implements OntIndividual.Anonymous {
        public AnonymousImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public boolean isLocal() {
            return this.hasLocalClassAssertions();
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.empty();
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntIndividual.Anonymous.class;
        }

        @Override
        public AnonymousImpl detachClass(Resource clazz) {
            Set classes = this.classes().collect(Collectors.toSet());
            if (clazz == null && !classes.isEmpty()) {
                throw new OntJenaException.IllegalState("Detaching classes is prohibited: the anonymous individual (" + this + ") should contain at least one class assertion, otherwise it can be lost");
            }
            if (classes.size() == 1 && ((OntClass)classes.iterator().next()).equals(clazz)) {
                throw new OntJenaException.IllegalState("Detaching class (" + clazz + ") is prohibited: it is a single class assertion for the individual " + this + ".");
            }
            this.remove(RDF.type, (RDFNode)clazz);
            return this;
        }
    }

    public static class NamedImpl
    extends OntIndividualImpl
    implements OntIndividual.Named {
        public NamedImpl(Node n, EnhGraph m) {
            super(NamedImpl.checkNamed(n), m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.of(this.getModel().createStatement(this, RDF.type, (RDFNode)OWL2.NamedIndividual).asRootStatement()).filter(r -> this.getModel().contains((Statement)r));
        }

        @Override
        public boolean isBuiltIn() {
            return false;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntIndividual.Named.class;
        }

        @Override
        public NamedImpl detachClass(Resource clazz) {
            OntGraphModelImpl m = this.getModel();
            m.listOntStatements(this, RDF.type, (RDFNode)clazz).filterDrop(s -> OWL2.NamedIndividual.equals((Object)s.getObject())).toList().forEach(s -> m.remove(s.clearAnnotations()));
            return this;
        }
    }
}

