/*
 * Decompiled with CFR 0.152.
 */
package rdfconnection.examples;

import java.io.OutputStream;
import java.util.List;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.sparql.resultset.ResultsFormat;

public class RDFConnectionExampleDBpedia01 {
    public static void main(String[] args) {
        List<String> acceptHeaders = List.of("application/sparql-results+thrift", "application/sparql-results+json");
        String queryString = "SELECT * { <http://dbpedia.org/resource/Apache_Jena> rdfs:label ?l } ORDER BY ?l LIMIT 1";
        for (String acceptHeader : acceptHeaders) {
            System.out.println("Trying to query with content type: " + acceptHeader);
            try (RDFConnection conn = RDFConnectionRemote.service((String)"http://dbpedia.org/sparql").acceptHeaderSelectQuery(acceptHeader).parseCheckSPARQL(false).build();){
                try (QueryExecution qe = conn.query(queryString);){
                    ResultSet rs = qe.execSelect();
                    ResultSetFormatter.output((OutputStream)System.out, (ResultSet)rs, (ResultsFormat)ResultsFormat.TEXT);
                }
                catch (Exception e) {
                    System.out.println("Request failed: " + e.getMessage());
                }
            }
            System.out.println();
        }
        System.out.println("Done.");
    }
}

