/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.auth;

import arq.examples.ExamplesServer;
import java.net.Authenticator;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;

public class ExAuth04_ServicePW {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;
    public static String rdfString;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServerWithAuth(dsName, dsg, true, "u", "p");
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            RDFParser.fromString((String)rdfString, (Lang)Lang.TTL).parse(dsg);
            ExAuth04_ServicePW.exampleServiceByRegistry();
            ExAuth04_ServicePW.exampleServiceByHttpClient();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void exampleServiceByRegistry() {
        System.out.println();
        System.out.println("Register user/password, then make SERVICE call");
        AuthEnv.get().registerUsernamePassword(URI.create(dataURL), "u", "p");
        Dataset emptyLocal = DatasetFactory.empty();
        Query query = QueryFactory.create((String)("SELECT * { SERVICE <" + dataURL + "> { ?s ?p ?o } }"));
        try (QueryExecution qExec = QueryExecution.create().query(query).dataset(emptyLocal).build();){
            System.out.println("Call using SERVICE...");
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
        AuthEnv.get().clearActiveAuthentication();
    }

    private static void exampleServiceByHttpClient() {
        System.out.println();
        System.out.println("Custom HttpClient + SERVICE call");
        Authenticator authenticator = AuthLib.authenticator((String)"u", (String)"p");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).authenticator(authenticator).build();
        Context cxt = ContextAccumulator.newBuilder().set(ARQ.httpQueryClient, (Object)httpClient).context();
        Query query = QueryFactory.create((String)("SELECT * { SERVICE <" + dataURL + "> { ?s ?p ?o } }"));
        Dataset emptyLocal = DatasetFactory.empty();
        try (QueryExecution qExec = QueryExecution.create().query(query).dataset(emptyLocal).context(cxt).build();){
            System.out.println("Call using SERVICE...");
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
    }

    static {
        rdfString = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example>", ":s :p 123 ."});
    }
}

