/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.auth;

import arq.examples.ExamplesServer;
import java.net.Authenticator;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;

public class ExAuth02_QueryExecutionPW {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServerWithAuth(dsName, dsg, false, "u", "p");
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            ExAuth02_QueryExecutionPW.exampleQueryAuthWithHttpClient();
            ExAuth02_QueryExecutionPW.exampleQueryAuth();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static void exampleQueryAuthWithHttpClient() {
        System.out.println();
        System.out.println("HttpClient + QueryExecutionHTTP");
        Authenticator authenticator = AuthLib.authenticator((String)"u", (String)"p");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).authenticator(authenticator).build();
        try (QueryExecution qexec = (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)dataURL).httpClient(httpClient)).endpoint(dataURL)).queryString("ASK{}")).build();){
            qexec.execAsk();
        }
    }

    public static void exampleQueryAuth() {
        System.out.println();
        try (QueryExecution qExec = (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)dataURL).query("ASK{}")).build();){
            try {
                System.out.println("Query/no auth");
                qExec.execAsk();
            }
            catch (QueryException ex) {
                System.out.println("Failed: " + ex.getMessage());
            }
        }
        System.out.println();
        AuthEnv.get().clearAuthEnv();
        System.out.println("Register user/password (with challenge)");
        AuthEnv.get().registerUsernamePassword(URI.create(dataURL), "u", "p");
        qExec = (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)dataURL).query("ASK{}")).build();
        try {
            System.out.println("Query/auth registered");
            qExec.execAsk();
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
        }
        AuthEnv.get().clearActiveAuthentication();
    }
}

