/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import arq.examples.ExamplesServer;
import java.io.OutputStream;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.query.ModelStore;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class ExModelStore01 {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    public static String rdfString = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example>", ":s :p 123 ."});
    static Model someData = ModelFactory.createDefaultModel();

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            FusekiServer server = ExamplesServer.startServer(dsName, dsg, false);
            String dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            RDFParser.fromString((String)rdfString, (Lang)Lang.TTL).parse(someData);
            ExModelStore01.exampleModelStore(dataURL);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void exampleModelStore(String dataURL) {
        System.out.println();
        System.out.println("ModelStore - PUT");
        ModelStore.service((String)dataURL).defaultModel().PUT(someData);
        System.out.println();
        System.out.println("ModelStore - GET");
        Model model = ModelStore.service((String)dataURL).defaultModel().GET();
        System.out.println();
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)Lang.TTL);
    }
}

