/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.auth;

import arq.examples.ExamplesServer;
import java.net.Authenticator;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTP;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTPBuilder;
import org.apache.jena.update.UpdateExecution;

public class ExAuth03_UpdateExecutionPW {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServerWithAuth(dsName, dsg, false, "u", "p");
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            ExAuth03_UpdateExecutionPW.exampleUpdateAuthWithHttpClient();
            ExAuth03_UpdateExecutionPW.exampleUpdateAuth();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static void exampleUpdateAuthWithHttpClient() {
        System.out.println();
        System.out.println("HttpClient + UpdateExecutionHTTP");
        Authenticator authenticator = AuthLib.authenticator((String)"u", (String)"p");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).authenticator(authenticator).build();
        ((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.service((String)dataURL).httpClient(httpClient)).update("CLEAR ALL")).execute();
    }

    public static void exampleUpdateAuth() {
        System.out.println();
        UpdateExecution uExec1 = (UpdateExecution)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.service((String)dataURL).update("INSERT DATA{}")).build();
        try {
            System.out.println("Update/no auth");
            uExec1.execute();
        }
        catch (HttpException ex) {
            System.out.println("Failed: " + ex.getMessage());
        }
        System.out.println("Register user/password + UpdateExecution");
        AuthEnv.get().registerUsernamePassword(URI.create(dataURL), "u", "p");
        UpdateExecution uExec3 = (UpdateExecution)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.service((String)dataURL).update("INSERT DATA{}")).build();
        uExec3.execute();
        AuthEnv.get().clearActiveAuthentication();
    }
}

