/*
 * Decompiled with CFR 0.152.
 */
package tdb2.examples;

import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.tdb2.TDB2Factory;

public class ExTDB6 {
    public static String MY_NS = "x-ns://example.org/ns1/";

    public static void main(String[] args) throws Exception {
        Dataset dataset = TDB2Factory.createDataset();
        dataset.executeRead(() -> {
            Iterator it = dataset.listNames();
            while (it.hasNext()) {
                System.out.println("NAME=" + (String)it.next());
            }
        });
        System.out.println("getting named model...");
        Model model = dataset.getNamedModel(MY_NS);
        dataset.executeRead(() -> {
            System.out.println("Model: " + model.size() + " statements");
            RDFWriter.source((Model)model).lang(Lang.TTL).output((OutputStream)System.out);
        });
        System.out.println("getting graph...");
        Graph graph = model.getGraph();
        dataset.executeRead(() -> {
            System.out.println("Graph: " + model.size() + " triples");
            RDFWriter.source((Graph)graph).lang(Lang.TTL).output((OutputStream)System.out);
        });
        dataset.executeWrite(() -> {
            if (graph.isEmpty()) {
                Resource product1 = model.createResource(MY_NS + "product/1");
                Property hasName = model.createProperty(MY_NS, "#hasName");
                Statement stmt = model.createStatement(product1, hasName, (RDFNode)model.createLiteral("Beach Ball", "en"));
                System.out.println("Statement = " + String.valueOf(stmt));
                model.add(stmt);
                System.out.println("Triple := " + stmt.asTriple().toString());
            } else {
                System.out.println("Graph is not Empty; it has " + graph.size() + " Statements");
                long t0 = System.currentTimeMillis();
                Query q = QueryFactory.create((String)"PREFIX exns: <\"+MY_NS+\"#>\nPREFIX exprod: <\"+MY_NS+\"product/>\nSELECT *\n// if you don't provide the Model to the\n// QueryExecutionFactory below, then you'll need\n// to specify the FROM;\n// you *can* always specify it, if you want\n// FROM <\"+MY_NS+\">\n\n// WHERE { ?node <\"+MY_NS+\"#hasName> ?name }\n// WHERE { ?node exns:hasName ?name }\n// WHERE { exprod:1 exns:hasName ?name }\nWHERE { ?res ?pred ?obj }\n");
                System.out.println("Query := " + String.valueOf(q));
                long t1 = System.currentTimeMillis();
                System.out.println("QueryFactory.TIME=" + (t1 - t0));
                t0 = System.currentTimeMillis();
                try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)model);){
                    t1 = System.currentTimeMillis();
                    System.out.println("QueryExecutionFactory.TIME=" + (t1 - t0));
                    t0 = System.currentTimeMillis();
                    ResultSet rs = qExec.execSelect();
                    t1 = System.currentTimeMillis();
                    System.out.println("executeSelect.TIME=" + (t1 - t0));
                    while (rs.hasNext()) {
                        QuerySolution sol = rs.next();
                        System.out.println("Solution := " + String.valueOf(sol));
                        Iterator names = sol.varNames();
                        while (names.hasNext()) {
                            String name = (String)names.next();
                            System.out.println("\t" + name + " := " + String.valueOf(sol.get(name)));
                        }
                    }
                }
            }
        });
    }
}

