/*
 * Decompiled with CFR 0.152.
 */
package shex.examples;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shex.ShapeMap;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.vocabulary.RDF;

public class Shex03_validate {
    public static void main(String ... args) {
        String SHAPES = "examples/schema.shex";
        String DATA = "examples/data.ttl";
        System.out.println("Read data");
        Graph dataGraph = RDFDataMgr.loadGraph((String)DATA);
        System.out.println("Read shapes");
        ShexSchema shapes = Shex.readSchema((String)SHAPES);
        Node myClass = NodeFactory.createURI((String)"http://example/myClass");
        Triple instancesOfFoo = Triple.create((Node)Shex.FOCUS, (Node)RDF.type.asNode(), (Node)myClass);
        Node shape1 = NodeFactory.createURI((String)"http://example/shapes#shape1");
        ShapeMap shapeMap = ShapeMap.newBuilder().add(instancesOfFoo, shape1).build();
        ShapeMap shapeMapAlt = ShapeMap.record((Triple)instancesOfFoo, (Node)shape1);
        System.out.println();
        System.out.println("Validate");
        ShexReport report = ShexValidator.get().validate(dataGraph, shapes, shapeMap);
        System.out.println();
        ShexLib.printReport((ShexReport)report);
    }

    static {
        LogCtl.setLogging();
    }
}

