/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.update;

import java.io.OutputStream;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecuteOperations {
    public static void main(String[] args) {
        Dataset dataset = DatasetFactory.createTxnMem();
        UpdateExecuteOperations.ex1(dataset);
        UpdateExecuteOperations.ex2(dataset);
        UpdateExecuteOperations.ex3(dataset);
    }

    public static void ex1(Dataset dataset) {
        UpdateAction.parseExecute((String)"LOAD <file:etc/update-data.ttl>", (Dataset)dataset);
    }

    public static void ex2(Dataset dataset) {
        String cmd = String.join((CharSequence)" ;\n", "DROP ALL", "CREATE GRAPH <http://example/g2>", "LOAD <file:etc/update-data.ttl> INTO GRAPH <http://example/g2>");
        System.out.println(cmd);
        UpdateAction.parseExecute((String)cmd, (Dataset)dataset);
    }

    public static void ex3(Dataset dataset) {
        UpdateRequest request = UpdateFactory.create();
        request.add("DROP ALL").add("CREATE GRAPH <http://example/g2>");
        UpdateFactory.parse((UpdateRequest)request, (String)"LOAD <file:etc/update-data.ttl> INTO GRAPH <http://example/g2>");
        UpdateAction.execute((UpdateRequest)request, (Dataset)dataset);
        System.out.println("# Debug format");
        SSE.write((Dataset)dataset);
        System.out.println();
        System.out.println("# N-Quads: S P O G");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.NQUADS);
    }

    static {
        LogCtl.setLogging();
    }
}

