/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.service;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.service.single.ServiceExecutor;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.QueryExecUtils;

public class CustomServiceExecutor {
    public static final String QUERY_STR = String.join((CharSequence)"\n", "PREFIX wd: <http://www.wikidata.org/entity/>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX dbr: <http://dbpedia.org/resource/>", "SELECT * {", "  SERVICE <http://query.wikidata.org/sparql> {", "    SELECT * {", "      ?s rdfs:label \"Apache Jena\"@en", "     } LIMIT 10", "  }", "}");
    public static final Node WIKIDATA = NodeFactory.createURI((String)"http://query.wikidata.org/sparql");
    public static final Node DBPEDIA = NodeFactory.createURI((String)"http://dbpedia.org/sparql");

    public static void main(String[] args) {
        Dataset dataset = DatasetFactory.empty();
        CustomServiceExecutor.conventionalExec(dataset);
        CustomServiceExecutor.relayWikidataToDBpediaChaining(dataset);
        CustomServiceExecutor.relayWikidataToDBpedia(dataset);
        CustomServiceExecutor.suppressRemoteRequests(dataset);
    }

    public static void conventionalExec(Dataset dataset) {
        CustomServiceExecutor.execQueryAndShowResult(dataset, QUERY_STR, null);
    }

    public static void relayWikidataToDBpediaChaining(Dataset dataset) {
        ChainingServiceExecutor relaySef = (opExecute, original, binding, execCxt, chain) -> {
            if (opExecute.getService().equals((Object)WIKIDATA)) {
                opExecute = new OpService(DBPEDIA, opExecute.getSubOp(), opExecute.getSilent());
            }
            return chain.createExecution(opExecute, original, binding, execCxt);
        };
        Context cxt = ARQ.getContext().copy();
        ServiceExecutorRegistry registry = ServiceExecutorRegistry.get((Context)cxt).copy();
        registry.addSingleLink(relaySef);
        ServiceExecutorRegistry.set((Context)cxt, (ServiceExecutorRegistry)registry);
        CustomServiceExecutor.execQueryAndShowResult(dataset, QUERY_STR, cxt);
    }

    public static void relayWikidataToDBpedia(Dataset dataset) {
        ServiceExecutor relaySef = (opExecute, original, binding, execCxt) -> {
            if (opExecute.getService().equals((Object)WIKIDATA)) {
                opExecute = new OpService(DBPEDIA, opExecute.getSubOp(), opExecute.getSilent());
                return ServiceExecutorRegistry.httpService.createExecution(opExecute, original, binding, execCxt);
            }
            return null;
        };
        Context cxt = ARQ.getContext().copy();
        ServiceExecutorRegistry registry = ServiceExecutorRegistry.get((Context)cxt).copy();
        registry.add(relaySef);
        ServiceExecutorRegistry.set((Context)cxt, (ServiceExecutorRegistry)registry);
        CustomServiceExecutor.execQueryAndShowResult(dataset, QUERY_STR, cxt);
    }

    public static void suppressRemoteRequests(Dataset dataset) {
        ServiceExecutor noop = (opExecute, original, binding, execCxt) -> QueryIterRoot.create((ExecutionContext)execCxt);
        Context cxt = ARQ.getContext().copy();
        ServiceExecutorRegistry registry = new ServiceExecutorRegistry();
        registry.add(noop);
        ServiceExecutorRegistry.set((Context)cxt, (ServiceExecutorRegistry)registry);
        CustomServiceExecutor.execQueryAndShowResult(dataset, QUERY_STR, cxt);
    }

    public static void execQueryAndShowResult(Dataset dataset, String queryStr, Context cxt) {
        try (QueryExec exec = QueryExecDatasetBuilder.create().dataset(dataset.asDatasetGraph()).query(queryStr).context(cxt).build();){
            QueryExecUtils.exec((QueryExec)exec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

