/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.engine;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.util.Context;

public class MyQueryEngine
extends QueryEngineMain {
    static QueryEngineFactory factory = new MyQueryEngineFactory();

    public MyQueryEngine(Query query, DatasetGraph dataset, Binding initial, Context context) {
        super(query, dataset, initial, context);
    }

    public MyQueryEngine(Query query, DatasetGraph dataset) {
        this(query, dataset, null, null);
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding initial, Context context) {
        MyTransform transform = new MyTransform();
        op = Transformer.transform((Transform)transform, (Op)op);
        return super.eval(op, dsg, initial, context);
    }

    protected Op modifyOp(Op op) {
        op = super.modifyOp(op);
        return op;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    static class MyTransform
    extends TransformCopy {
        MyTransform() {
        }

        public Op transform(OpBGP opBGP) {
            return opBGP;
        }
    }

    static class MyQueryEngineFactory
    implements QueryEngineFactory {
        MyQueryEngineFactory() {
        }

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Query query, DatasetGraph dataset, Binding initial, Context context) {
            MyQueryEngine engine = new MyQueryEngine(query, dataset, initial, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return false;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            throw new ARQInternalErrorException("MyQueryEngine: factory calleddirectly with an algebra expression");
        }
    }
}

