/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import java.io.OutputStream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.vocabulary.DC;

public class ExProg2 {
    public static final String NL = System.getProperty("line.separator");

    public static void main(String[] args) {
        Model model = ExProg2.createModel();
        Query query = QueryFactory.make();
        query.setQuerySelectType();
        ElementGroup elg = new ElementGroup();
        Var varTitle = Var.alloc((String)"title");
        Var varX = Var.alloc((String)"x");
        Triple t1 = Triple.create((Node)varX, (Node)DC.title.asNode(), (Node)varTitle);
        elg.addTriplePattern(t1);
        E_Regex expr = new E_Regex((Expr)new ExprVar(varTitle), "sparql", "i");
        ElementFilter filter = new ElementFilter((Expr)expr);
        elg.addElementFilter(filter);
        query.setQueryPattern((Element)elg);
        query.addResultVar((Node)varTitle);
        query.getPrefixMapping().setNsPrefix("dc", DC.getURI());
        query.serialize(new IndentedWriter((OutputStream)System.out, true));
        System.out.println();
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet rs = qexec.execSelect();
            System.out.println("Titles: ");
            while (rs.hasNext()) {
                QuerySolution rb = rs.nextSolution();
                RDFNode x = rb.get("title");
                if (x instanceof Literal) {
                    Literal titleStr = (Literal)x;
                    System.out.println("    " + String.valueOf(titleStr));
                    continue;
                }
                System.out.println("Strange - not a literal: " + String.valueOf(x));
            }
        }
    }

    public static Model createModel() {
        Model model = ModelFactory.createDefaultModel();
        Resource r1 = model.createResource("http://example.org/book#1");
        Resource r2 = model.createResource("http://example.org/book#2");
        Resource r3 = model.createResource("http://example.org/book#3");
        r1.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        r3.addProperty(DC.title, "Jena - an RDF framework for Java").addProperty(DC.description, "A book about Jena");
        return model;
    }
}

