/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import arq.examples.ExamplesServer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.sys.HttpRequestModifier;
import org.apache.jena.http.sys.RegistryRequestModifier;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.http.GSP;

public class ExModification01 {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServer(dsName, dsg, true);
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            ExModification01.exampleMod();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void exampleMod() {
        AtomicLong counter = new AtomicLong(0L);
        HttpRequestModifier modifier = (params, headers) -> {
            long x = counter.incrementAndGet();
            headers.put("X-Tracker", "Call=" + x);
        };
        RegistryRequestModifier.get().addPrefix((Object)serverURL, (Object)modifier);
        GSP.service((String)dataURL).defaultGraph().GET();
        try (RDFLink link = RDFLinkHTTP.service((String)dataURL).build();){
            boolean bl = link.queryAsk("ASK{}");
        }
    }
}

