/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdUpdate;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.graph.GraphLoadMonitor;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;

public class load
extends CmdUpdate {
    private static final ArgDecl graphNameArg = new ArgDecl(true, "--graph");
    private static final ArgDecl dumpArg = new ArgDecl(false, "--dump");
    String graphName = null;
    List<String> loadFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new load(argv).mainRun();
    }

    protected load(String[] argv) {
        super(argv);
        super.add(graphNameArg, "--graph=IRI", "Graph IRI (loads default graph if absent)");
        super.add(dumpArg, "--dump", "Dump the resulting graph store");
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.containsMultiple(graphNameArg)) {
            throw new CmdException("At most one --graph allowed");
        }
        this.graphName = this.getValue(graphNameArg);
        this.loadFiles = super.getPositional();
        this.dump = this.contains(dumpArg);
        super.processModulesAndArgs();
    }

    @Override
    protected String getCommandName() {
        return Lib.className((Object)this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    @Override
    protected void execUpdate(DatasetGraph dataset) {
        if (this.loadFiles.size() == 0) {
            throw new CmdException("Nothing to do");
        }
        UpdateRequest req = new UpdateRequest();
        for (String filename : this.loadFiles) {
            UpdateLoad loadReq = new UpdateLoad(filename, this.graphName);
            req.add((Update)loadReq);
        }
        this.monitor(dataset.getDefaultGraph());
        Iterator iter = dataset.listGraphNodes();
        while (iter.hasNext()) {
            Graph g = dataset.getGraph((Node)iter.next());
            this.monitor(g);
        }
        UpdateExec.newBuilder().update(req).dataset(dataset).execute();
        if (this.dump) {
            IndentedWriter out = IndentedWriter.stdout;
            SSE.write((DatasetGraph)dataset);
            out.flush();
        }
    }

    private void monitor(Graph graph) {
        GraphLoadMonitor m = new GraphLoadMonitor(20000, false);
        graph.getEventManager().register((GraphListener)m);
    }

    @Override
    protected DatasetGraph dealWithNoDataset() {
        throw new CmdException("No dataset provided");
    }
}

