/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;

public class ImageNameToOperatingSystem
implements Function<String, OperatingSystem> {
    public OperatingSystem apply(String input) {
        String name = input.contains("backports") ? input.substring(input.indexOf("backports-") + 10) : input;
        OperatingSystem.Builder builder = this.defaultOperatingSystem(name);
        ArrayList splits = Lists.newArrayList((Object[])name.split("-"));
        if (splits == null || splits.size() == 0 || splits.size() < 3) {
            return builder.build();
        }
        String os = (String)splits.get(0);
        if ("opensuse".equals(os) || "sles".equals(os)) {
            builder.family(OsFamily.SUSE);
        } else {
            OsFamily family = OsFamily.fromValue((String)os);
            if (family != OsFamily.UNRECOGNIZED) {
                builder.family(family);
            }
        }
        String version = Joiner.on((String)".").join(Iterables.limit((Iterable)Iterables.skip((Iterable)splits, (int)1), (int)(splits.size() - 2)));
        builder.version(version);
        return builder.build();
    }

    private OperatingSystem.Builder defaultOperatingSystem(String name) {
        return OperatingSystem.builder().family(OsFamily.LINUX).is64Bit(true).description(name);
    }
}

