/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Node {
    private final String zone;
    private final String fqdn;

    public static Node create(String zone, String fqdn) {
        return new Node(zone, fqdn);
    }

    @ConstructorProperties(value={"zone", "fqdn"})
    protected Node(String zone, String fqdn) {
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.zone = (String)Preconditions.checkNotNull((Object)zone, (String)"zone for %s", (Object)fqdn);
    }

    public String getZone() {
        return this.zone;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zone, this.fqdn});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node that = (Node)Node.class.cast(obj);
        return Objects.equal((Object)this.zone, (Object)that.zone) && Objects.equal((Object)this.fqdn, (Object)that.fqdn);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("zone", (Object)this.zone).add("fqdn", (Object)this.fqdn).toString();
    }
}

