/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public class CatalogItemOptions {
    private String description;
    private Map<String, String> properties = Maps.newLinkedHashMap();

    public CatalogItemOptions description(String description) {
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        return this;
    }

    public CatalogItemOptions properties(Map<String, String> properties) {
        this.properties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(properties, (Object)"properties")));
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        public static CatalogItemOptions description(String description) {
            return new CatalogItemOptions().description(description);
        }

        public static CatalogItemOptions properties(Map<String, String> properties) {
            return new CatalogItemOptions().properties(properties);
        }
    }
}

