/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.VAppHandler;
import org.jclouds.vcloud.xml.VmHandlerTest;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VAppHandlerTest {
    public void testRhelOffStatic() {
        InputStream is = this.getClass().getResourceAsStream("/vapp-rhel-off-static.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            protected void configure() {
                super.configure();
                this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
            }
        }});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VApp result = (VApp)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"vApp_acole_2");
        Assert.assertEquals((String)result.getDescription(), (String)"foo");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vapp-607806320"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.vApp+xml");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1014839439")));
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        assert (result.isOvfDescriptorUploaded());
        assert (result.getNetworkSection() != null);
        Vm vm = (Vm)Iterables.getOnlyElement((Iterable)result.getChildren());
        VmHandlerTest.checkVm(vm);
    }
}

