/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.NetworkConnectionHandlerTest;
import org.jclouds.vcloud.xml.NetworkConnectionSectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NetworkConnectionSectionHandlerTest {
    public void testVCloud1_0() {
        InputStream is = this.getClass().getResourceAsStream("/networkconnectionsection.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        NetworkConnectionSection result = (NetworkConnectionSection)factory.create((ParseSax.HandlerWithResult)injector.getInstance(NetworkConnectionSectionHandler.class)).parse(is);
        NetworkConnectionSectionHandlerTest.checkNetworkConnectionSection(result);
    }

    @Test(enabled=false)
    static void checkNetworkConnectionSection(NetworkConnectionSection result) {
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/networkConnectionSection/"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.networkConnectionSection+xml");
        Assert.assertEquals((String)result.getInfo(), (String)"Specifies the available VM network connections");
        Assert.assertEquals((Object)result.getPrimaryNetworkConnectionIndex(), (Object)0);
        Assert.assertEquals((Object)result.getEdit(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.networkConnectionSection+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/networkConnectionSection/")));
        NetworkConnectionHandlerTest.checkNetworkConnection((NetworkConnection)Iterables.getOnlyElement((Iterable)result.getConnections()));
    }
}

