/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.ReferenceType;

public class OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault
implements Function<Iterable<ReferenceType>, ReferenceType> {
    protected final ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull;
    protected final String configurationKey;
    protected final Predicate<ReferenceType> defaultSelector;

    public OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, String configurationKey, Predicate<ReferenceType> defaultSelector) {
        this.configurationKey = (String)Preconditions.checkNotNull((Object)configurationKey, (Object)"configurationKey");
        this.valueOfConfigurationKeyOrNull = (ValueOfConfigurationKeyOrNull)Preconditions.checkNotNull((Object)valueOfConfigurationKeyOrNull, (Object)"valueOfConfigurationKeyOrNull");
        this.defaultSelector = (Predicate)Preconditions.checkNotNull(defaultSelector, (Object)"defaultSelector");
    }

    public ReferenceType apply(Iterable<ReferenceType> referenceTypes) {
        Preconditions.checkNotNull(referenceTypes, (Object)"referenceTypes");
        Preconditions.checkArgument((Iterables.size(referenceTypes) > 0 ? 1 : 0) != 0, (String)"No referenceTypes corresponding to configuration key %s present", (Object[])new Object[]{this.configurationKey});
        if (Iterables.size(referenceTypes) == 1) {
            return (ReferenceType)Iterables.getLast(referenceTypes);
        }
        String namingPattern = this.valueOfConfigurationKeyOrNull.apply(this.configurationKey);
        if (namingPattern != null) {
            return this.findReferenceTypeWithNameMatchingPattern(referenceTypes, namingPattern);
        }
        return this.defaultReferenceType(referenceTypes);
    }

    public ReferenceType defaultReferenceType(Iterable<ReferenceType> referenceTypes) {
        return (ReferenceType)Iterables.find(referenceTypes, this.defaultSelector);
    }

    public ReferenceType findReferenceTypeWithNameMatchingPattern(Iterable<ReferenceType> referenceTypes, String namingPattern) {
        try {
            return (ReferenceType)Iterables.find(referenceTypes, (Predicate)new ReferenceTypeNameMatchesPattern(namingPattern));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("referenceType matching pattern [%s], corresponding to configuration key %s, not in %s", namingPattern, this.configurationKey, referenceTypes));
        }
    }

    static class ReferenceTypeNameMatchesPattern
    implements Predicate<ReferenceType> {
        private final String namingPattern;

        public ReferenceTypeNameMatchesPattern(String namingPattern) {
            this.namingPattern = (String)Preconditions.checkNotNull((Object)namingPattern, (Object)"namingPattern");
        }

        public boolean apply(ReferenceType arg0) {
            return arg0.getName().matches(this.namingPattern);
        }

        public String toString() {
            return "nameMatchesPattern(" + this.namingPattern + ")";
        }
    }
}

