/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.FenceMode;

public class NetworkConfig {
    @Nullable
    private final String networkName;
    private final URI parentNetwork;
    @Nullable
    private final FenceMode fenceMode;

    public Builder toBuilder() {
        return NetworkConfig.builder().fromNetworkConfig(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public NetworkConfig(String networkName, URI parentNetwork, FenceMode fenceMode) {
        this.networkName = networkName;
        this.parentNetwork = (URI)Preconditions.checkNotNull((Object)parentNetwork, (Object)"parentNetwork");
        this.fenceMode = fenceMode;
    }

    public NetworkConfig(URI parentNetwork) {
        this(null, parentNetwork, null);
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public URI getParentNetwork() {
        return this.parentNetwork;
    }

    public FenceMode getFenceMode() {
        return this.fenceMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fenceMode == null ? 0 : this.fenceMode.hashCode());
        result = 31 * result + (this.parentNetwork == null ? 0 : this.parentNetwork.hashCode());
        result = 31 * result + (this.networkName == null ? 0 : this.networkName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkConfig other = (NetworkConfig)obj;
        if (this.fenceMode == null ? other.fenceMode != null : !this.fenceMode.equals((Object)other.fenceMode)) {
            return false;
        }
        if (this.parentNetwork == null ? other.parentNetwork != null : !this.parentNetwork.equals(other.parentNetwork)) {
            return false;
        }
        return !(this.networkName == null ? other.networkName != null : !this.networkName.equals(other.networkName));
    }

    public String toString() {
        return "[networkName=" + this.networkName + ", parentNetwork=" + this.parentNetwork + ", fenceMode=" + (Object)((Object)this.fenceMode) + "]";
    }

    public static class Builder {
        private String networkName;
        private URI parentNetwork;
        private FenceMode fenceMode;

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public Builder parentNetwork(URI parentNetwork) {
            this.parentNetwork = parentNetwork;
            return this;
        }

        public Builder fenceMode(FenceMode fenceMode) {
            this.fenceMode = fenceMode;
            return this;
        }

        public Builder fromNetworkConfig(NetworkConfig in) {
            return this.networkName(in.getNetworkName()).parentNetwork(in.getParentNetwork()).fenceMode(in.getFenceMode());
        }

        public NetworkConfig build() {
            return new NetworkConfig(this.networkName, this.parentNetwork, this.fenceMode);
        }
    }
}

