/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.firewall.FirewallRule;

public class FirewallService {
    private final boolean enabled;
    List<FirewallRule> firewallRules = Lists.newArrayList();

    public FirewallService(boolean enabled, Iterable<FirewallRule> firewallRules) {
        this.enabled = enabled;
        Iterables.addAll(this.firewallRules, (Iterable)((Iterable)Preconditions.checkNotNull(firewallRules, (Object)"firewallRules")));
    }

    public List<FirewallRule> getFirewallRules() {
        return this.firewallRules;
    }

    @Nullable
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirewallService that = (FirewallService)FirewallService.class.cast(o);
        return Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal(this.firewallRules, that.firewallRules);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.firewallRules});
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((String)"").omitNullValues().add("enabled", this.enabled);
        if (this.firewallRules.size() > 0) {
            helper.add("firewallRules", this.firewallRules);
        }
        return helper.toString();
    }
}

