/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.features.CatalogApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.options.CatalogItemOptions;
import org.jclouds.vcloud.xml.CatalogHandler;
import org.jclouds.vcloud.xml.CatalogItemHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CatalogApiTest")
public class CatalogApiTest
extends BaseVCloudApiTest<CatalogApi> {
    public void testCatalog() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CatalogApi.class, (String)"getCatalog", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalog/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/catalog/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalogInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CatalogApi.class, (String)"findCatalogInOrgNamed", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"catalog"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/catalog/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalogItemURI() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CatalogApi.class, (String)"getCatalogItem", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalogItem/2")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/catalogItem/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindCatalogItemInOrgCatalogNamed() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CatalogApi.class, (String)"findCatalogItemInOrgCatalogNamed", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"catalog", (Object)"item"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/catalogItem/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddVAppTemplateOrMediaImageToCatalogAndNameItem() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CatalogApi.class, (String)"addVAppTemplateOrMediaImageToCatalogAndNameItem", (Class[])new Class[]{URI.class, URI.class, String.class, CatalogItemOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("http://fooentity"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalog/1"), (Object)"myname", (Object)CatalogItemOptions.Builder.description((String)"mydescription")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/catalog/1/catalogItems HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<CatalogItem xmlns=\"http://www.vmware.com/vcloud/v1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"myname\" xsi:schemaLocation=\"http://www.vmware.com/vcloud/v1 http://vcloud.safesecureweb.com/ns/vcloud.xsd\"><Description>mydescription</Description><Entity href=\"http://fooentity\"/></CatalogItem>", "application/vnd.vmware.vcloud.catalogItem+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

