/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.compute.config.VCloudComputeServiceContextModule;
import org.jclouds.vcloud.config.VCloudHttpApiModule;
import org.jclouds.vcloud.domain.network.FenceMode;

public class VCloudApiMetadata
extends BaseHttpApiMetadata<VCloudApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public VCloudApiMetadata() {
        this(new Builder());
    }

    protected VCloudApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.vcloud.version.schema", "1");
        properties.setProperty("jclouds.vcloud.xml.ns", String.format("http://www.vmware.com/vcloud/v${%s}", "jclouds.vcloud.version.schema"));
        properties.setProperty("jclouds.session-interval", "480");
        properties.setProperty("jclouds.vcloud.xml.schema", "http://vcloud.safesecureweb.com/ns/vcloud.xsd");
        properties.setProperty("jclouds.dns_name_length_min", "1");
        properties.setProperty("jclouds.dns_name_length_max", "80");
        properties.setProperty("jclouds.vcloud.defaults.fencemode", FenceMode.BRIDGED.toString());
        properties.setProperty("jclouds.vcloud.timeout.task-complete", "1200000");
        properties.setProperty("jclouds.session-interval", "300");
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,os64Bit=true");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<VCloudApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("vcloud")).name("VCloud 1.0 API")).identityName("User at Organization (user@org)")).credentialName("Password")).documentation(URI.create("http://www.vmware.com/support/pubs/vcd_pubs.html"))).version("1.0")).defaultProperties(VCloudApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.of(VCloudHttpApiModule.class, VCloudComputeServiceContextModule.class));
        }

        public VCloudApiMetadata build() {
            return new VCloudApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

