/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.features.VAppApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VAppHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VAppApiTest")
public class VAppApiTest
extends BaseVCloudApiTest<VAppApi> {
    public void testopyVAppToVDCAndName() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"copyVAppToVDCAndName", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vapp/4181"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"my-vapp"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/copyVApp-default.xml")), "application/vnd.vmware.vcloud.cloneVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCopyVAppToVDCAndNameOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"copyVAppToVDCAndName", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vapp/201"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"new-linux-server", (Object)new CloneVAppOptions().deploy().powerOn().description("The description of the new vApp")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/copyVApp.xml")), "application/vnd.vmware.vcloud.cloneVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testMoveVAppToVDCAndRenameOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"moveVAppToVDCAndRename", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vapp/201"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"new-linux-server", (Object)new CloneVAppOptions().deploy().powerOn().description("The description of the new vApp")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/moveVApp.xml")), "application/vnd.vmware.vcloud.cloneVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeployVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"deployVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/deploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<DeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\"/>", "application/vnd.vmware.vcloud.deployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeployAndPowerOnVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"deployAndPowerOnVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/deploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<DeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\" powerOn=\"true\"/>", "application/vnd.vmware.vcloud.deployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"getVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebootVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"rebootVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/reboot HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUndeployVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"undeployVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/undeploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\"/>", "application/vnd.vmware.vcloud.undeployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUndeployAndSaveStateOfVAppSaveState() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"undeployAndSaveStateOfVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/undeploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\" saveState=\"true\"/>", "application/vnd.vmware.vcloud.undeployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"deleteVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcenterprise.bluelock.com/api/v1.0/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOnVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"powerOnVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/powerOn HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOffVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"powerOffVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/powerOff HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResetVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"resetVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testSuspendVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"suspendVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/suspend HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testShutdownVApp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppApi.class, (String)"shutdownVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

