/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.util.Predicates2;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.internal.BaseVCloudApiLiveTest;
import org.jclouds.vcloud.options.CaptureVAppOptions;
import org.jclouds.vcloud.options.CatalogItemOptions;
import org.jclouds.vcloud.predicates.TaskSuccess;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="VAppTemplateApiLiveTest")
public class VAppTemplateApiLiveTest
extends BaseVCloudApiLiveTest {
    @Test
    public void testGetVAppTemplate() throws Exception {
        Org org = this.getVCloudApi().getOrgApi().findOrgNamed(null);
        for (ReferenceType cat : org.getCatalogs().values()) {
            Catalog response = this.getVCloudApi().getCatalogApi().getCatalog(cat.getHref());
            for (ReferenceType resource : response.values()) {
                VAppTemplate template;
                CatalogItem item;
                if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = this.getVCloudApi().getCatalogApi().getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml") || (template = this.getVCloudApi().getVAppTemplateApi().getVAppTemplate(item.getEntity().getHref())) == null) continue;
                Assert.assertEquals((Object)template.getHref(), (Object)item.getEntity().getHref());
            }
        }
    }

    @Test
    public void testGetOvfEnvelopeForVAppTemplate() throws Exception {
        Org org = this.getVCloudApi().getOrgApi().findOrgNamed(null);
        for (ReferenceType cat : org.getCatalogs().values()) {
            Catalog response = this.getVCloudApi().getCatalogApi().getCatalog(cat.getHref());
            for (ReferenceType resource : response.values()) {
                CatalogItem item;
                if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = this.getVCloudApi().getCatalogApi().getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) continue;
                this.getVCloudApi().getVAppTemplateApi().getOvfEnvelopeForVAppTemplate(item.getEntity().getHref());
            }
        }
    }

    @Test
    public void testFindVAppTemplate() throws Exception {
        Org org = this.getVCloudApi().getOrgApi().findOrgNamed(null);
        for (ReferenceType cat : org.getCatalogs().values()) {
            Catalog response = this.getVCloudApi().getCatalogApi().getCatalog(cat.getHref());
            for (ReferenceType resource : response.values()) {
                VAppTemplate template;
                CatalogItem item;
                if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = this.getVCloudApi().getCatalogApi().getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml") || (template = this.getVCloudApi().getVAppTemplateApi().findVAppTemplateInOrgCatalogNamed(org.getName(), response.getName(), item.getEntity().getName())) == null) continue;
                Assert.assertEquals((Object)template.getHref(), (Object)item.getEntity().getHref());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaptureVApp() throws Exception {
        String group = this.prefix + "cap";
        NodeMetadata node = null;
        VAppTemplate vappTemplate = null;
        CatalogItem item = null;
        try {
            node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1));
            Predicate taskTester = Predicates2.retry((Predicate)new TaskSuccess(this.getVCloudApi()), (long)600L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            Task task = this.getVCloudApi().getVAppApi().undeployVApp(URI.create(node.getId()));
            assert (taskTester.apply((Object)task.getHref())) : node;
            VApp vApp = this.getVCloudApi().getVAppApi().getVApp(URI.create(node.getId()));
            Assert.assertEquals((Object)vApp.getStatus(), (Object)Status.OFF);
            vappTemplate = this.getVCloudApi().getVAppTemplateApi().captureVAppAsTemplateInVDC(URI.create(node.getId()), group, URI.create(node.getLocation().getId()), new CaptureVAppOptions[0]);
            Assert.assertEquals((String)vappTemplate.getName(), (String)group);
            task = (Task)vappTemplate.getTasks().get(0);
            assert (taskTester.apply((Object)task.getHref())) : vappTemplate;
            item = this.getVCloudApi().getCatalogApi().addVAppTemplateOrMediaImageToCatalogAndNameItem(vappTemplate.getHref(), this.getVCloudApi().getCatalogApi().findCatalogInOrgNamed(null, null).getHref(), "fooname", new CatalogItemOptions[]{CatalogItemOptions.Builder.description((String)"description").properties((Map)ImmutableMap.of((Object)"foo", (Object)"bar"))});
            Assert.assertEquals((String)item.getName(), (String)"fooname");
            Assert.assertEquals((String)item.getDescription(), (String)"description");
            Assert.assertEquals((Map)item.getProperties(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
            Assert.assertEquals((String)item.getEntity().getName(), (String)"fooname");
            Assert.assertEquals((Object)item.getEntity().getHref(), (Object)vappTemplate.getHref());
            Assert.assertEquals((String)item.getEntity().getType(), (String)vappTemplate.getType());
        }
        finally {
            if (item != null) {
                this.getVCloudApi().getCatalogApi().deleteCatalogItem(item.getHref());
            }
            if (vappTemplate != null) {
                this.getVCloudApi().getVAppTemplateApi().deleteVAppTemplate(vappTemplate.getHref());
            }
            if (node != null) {
                this.client.destroyNode(node.getId());
            }
        }
    }
}

