/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml.ovf;

import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.ovf.VCloudOperatingSystemSection;
import org.jclouds.vcloud.xml.ovf.VCloudOperatingSystemHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudOperatingSystemSectionHandlerTest")
public class VCloudOperatingSystemSectionHandlerTest
extends BaseHandlerTest {
    public void testDefault() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/os.xml");
        VCloudOperatingSystemSection result = (VCloudOperatingSystemSection)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudOperatingSystemHandler.class)).parse(is);
        VCloudOperatingSystemSectionHandlerTest.checkOs(result);
    }

    @Test(enabled=false)
    public static void checkOs(VCloudOperatingSystemSection result) {
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/operatingSystemSection/"));
        Assert.assertEquals((String)result.getDescription(), (String)"Red Hat Enterprise Linux 5 (64-bit)");
        Assert.assertEquals((Object)result.getEdit(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.operatingSystemSection+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/operatingSystemSection/")));
        Assert.assertEquals((Object)result.getId(), (Object)80);
        Assert.assertEquals((String)result.getVmwOsType(), (String)"rhel5_64Guest");
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.operatingSystemSection+xml");
        Assert.assertEquals((String)result.getInfo(), (String)"Specifies the operating system installed");
    }
}

