/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.io.InputStream;
import java.net.URI;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.VCloudError;
import org.jclouds.vcloud.domain.internal.ErrorImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.internal.TaskImpl;
import org.jclouds.vcloud.xml.TaskHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TaskHandlerTest")
public class TaskHandlerTest
extends BaseHandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
    }

    public void testHrefWhenTaskElementIsNamespaced() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-vcd15.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://mycloud.greenhousedata.com/api/v1.0/task/77a33fd4-3401-423c-8167-6711fc51ee9a"));
    }

    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-1.0.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://vcenterprise.bluelock.com/api/v1.0/task/3cc08ir8oczbze3n1a3"), "Creating Virtual Application vApp_acole_2(607806320)", TaskStatus.RUNNING, this.dateService.iso8601DateParse("2010-08-23T02:09:52.443-04:00"), this.dateService.iso8601DateParse("9999-12-31T23:59:59.999-05:00"), this.dateService.iso8601DateParse("2010-11-21T02:09:52.443-05:00"), (ReferenceType)new ReferenceTypeImpl("vApp_acole_2", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vapp-607806320")), null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testTerremark() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/task/3299"), null, TaskStatus.SUCCESS, this.dateService.iso8601DateParse("2009-08-24T21:29:32.983Z"), this.dateService.iso8601DateParse("2009-08-24T21:29:44.65Z"), null, (ReferenceType)new ReferenceTypeImpl("Server1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/4012")), null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testSelf() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-self.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://vcloud.safesecureweb.com/api/v0.8/task/d188849-78"), null, TaskStatus.QUEUED, null, null, null, null, null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testApplyInputStream2() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-hosting.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://vcloud.safesecureweb.com/api/v0.8/task/97806"), null, TaskStatus.SUCCESS, this.dateService.iso8601SecondsDateParse("2010-01-14T20:04:51Z"), this.dateService.iso8601SecondsDateParse("2010-01-14T20:05:02Z"), this.dateService.iso8601SecondsDateParse("2010-01-15T20:05:02Z"), (ReferenceType)new ReferenceTypeImpl("188849-96", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vapp/188849-96")), null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testError() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-error.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("http://10.150.4.49/api/v0.8/task/23"), null, TaskStatus.ERROR, this.dateService.iso8601SecondsDateParse("2009-12-07T19:05:02Z"), this.dateService.iso8601SecondsDateParse("2009-12-10T14:40:32Z"), null, (ReferenceType)new ReferenceTypeImpl("testapp1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("http://10.150.4.49/api/v0.8/vapp/1")), (VCloudError)new ErrorImpl("Error processing job", 500, VCloudError.MinorCode.UNRECOGNIZED, " Error in runDailySummaries date used:2009-12-09 19:40:30.577326+00:00", null));
        Assert.assertEquals((Object)result, (Object)expects);
    }
}

