/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.location.Provider;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.endpoints.VCloudLogin;
import org.jclouds.vcloud.functions.ParseLoginResponseFromHeaders;
import org.jclouds.vcloud.internal.VCloudLoginAsyncClient;
import org.jclouds.vcloud.internal.VCloudLoginClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudLoginAsyncClientTest")
public class VCloudLoginAsyncClientTest
extends BaseAsyncClientTest<VCloudLoginAsyncClient> {
    public void testLogin() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VCloudLoginAsyncClient.class, (String)"login", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        Assert.assertEquals((String)request.getRequestLine(), (String)"POST http://localhost:8080/login HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.orgList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseLoginResponseFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected Module createModule() {
        return new Module(){

            public void configure(Binder binder) {
            }

            @Provides
            @VCloudLogin
            Supplier<URI> provideURI(@Provider Supplier<URI> uri) {
                return uri;
            }
        };
    }

    protected ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(VCloudLoginClient.class, VCloudLoginAsyncClient.class, (String)"http://localhost:8080/login");
    }
}

