/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.net.HostAndPort;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.rest.RestContext;
import org.jclouds.vcloud.VCloudApiMetadata;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.internal.BaseVCloudClientLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="VmClientLiveTest")
public class VmClientLiveTest
extends BaseVCloudClientLiveTest {
    protected String iLoveAscii = "I '\"love\"' {asc|!}*&";
    String script = "cat > /root/foo.txt<<EOF\n" + this.iLoveAscii + "\nEOF\n";

    @Test
    public void testGetThumbnailOfVm() throws Exception {
        Org org = this.getVCloudApi().getOrgClient().findOrgNamed(null);
        for (ReferenceType vdc : org.getVDCs().values()) {
            VDC response = this.getVCloudApi().getVDCClient().getVDC(vdc.getHref());
            for (ReferenceType item : response.getResourceEntities().values()) {
                if (!item.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                try {
                    VApp app = this.getVCloudApi().getVAppClient().getVApp(item.getHref());
                    Assert.assertNotNull((Object)app);
                    for (Vm vm : app.getChildren()) {
                        assert (this.getVCloudApi().getVmClient().getScreenThumbnailForVm(vm.getHref()) != null);
                    }
                }
                catch (RuntimeException e) {
                }
            }
        }
    }

    @Test
    public void testGetVm() throws Exception {
        Org org = this.getVCloudApi().getOrgClient().findOrgNamed(null);
        for (ReferenceType vdc : org.getVDCs().values()) {
            VDC response = this.getVCloudApi().getVDCClient().getVDC(vdc.getHref());
            for (ReferenceType item : response.getResourceEntities().values()) {
                if (!item.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                try {
                    VApp app = this.getVCloudApi().getVAppClient().getVApp(item.getHref());
                    Assert.assertNotNull((Object)app);
                    for (Vm vm : app.getChildren()) {
                        Assert.assertEquals((Object)this.getVCloudApi().getVmClient().getVm(vm.getHref()).getHref(), (Object)vm.getHref());
                    }
                }
                catch (RuntimeException e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtendedOptionsWithCustomizationScript() throws Exception {
        String PARSE_VMTOOLSD = "vmtoolsd --cmd=\"info-get guestinfo.ovfenv\" |grep vCloud_CustomizationInfo|sed 's/.*value=\"\\(.*\\)\".*/\\1/g'";
        String group = this.prefix + "cus";
        NodeMetadata node = null;
        try {
            TemplateOptions options = this.client.templateOptions();
            options.blockOnPort(22, 180);
            ((VCloudTemplateOptions)options.as(VCloudTemplateOptions.class)).customizationScript(this.script);
            ((VCloudTemplateOptions)options.as(VCloudTemplateOptions.class)).description(group);
            node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1, options));
            VApp vapp = ((VCloudClient)((RestContext)this.client.getContext().unwrap(VCloudApiMetadata.CONTEXT_TOKEN)).getApi()).getVAppClient().getVApp(node.getUri());
            Assert.assertEquals((String)vapp.getDescription(), (String)group);
            Vm vm = (Vm)Iterables.get((Iterable)vapp.getChildren(), (int)0);
            String apiOutput = vm.getGuestCustomizationSection().getCustomizationScript();
            this.checkApiOutput(apiOutput);
            ExecResponse vmTools = this.client.runScriptOnNode(node.getId(), PARSE_VMTOOLSD, RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            this.checkApiOutput(new String(BaseEncoding.base64().decode((CharSequence)vmTools.getOutput().trim()), Charsets.UTF_8));
            ExecResponse foo = this.client.runScriptOnNode(node.getId(), "cat /root/foo.txt", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            this.checkCustomizationOccurred(foo);
        }
        finally {
            if (node != null) {
                this.client.destroyNode(node.getId());
            }
        }
    }

    protected void checkCustomizationOccurred(ExecResponse exec) {
        assert (exec.getOutput().equals(this.iLoveAscii + "\r\n")) : exec;
    }

    protected void checkApiOutput(String apiOutput) {
        this.checkApiOutput1_0_1(apiOutput);
    }

    protected void checkApiOutput1_0_1(String apiOutput) {
        Assert.assertEquals((String)apiOutput, (String)this.script);
    }

    protected void checkApiOutput1_0_0(String apiOutput) {
        Assert.assertEquals((String)apiOutput, (String)this.script.replace("\n", ""));
    }

    protected HostAndPort getSocket(NodeMetadata node) {
        return HostAndPort.fromParts((String)((String)Iterables.get((Iterable)node.getPublicAddresses(), (int)0)), (int)22);
    }
}

